<?php
session_start();
require '../config/db.php';

if (!isset($_SESSION['manager_id'])) {
    die('Unauthorized');
}

/* ===============================
   ASSIGN DESIGNER
================================ */
if(isset($_POST['assign'])){
    $project_id  = $_POST['project_id'];
    $designer_id = $_POST['designer_id'];

    $designer = $pdo->prepare("SELECT full_name FROM design_employees WHERE id=?");
    $designer->execute([$designer_id]);
    $designer_name = $designer->fetchColumn();

    if($designer_name){
        $pdo->prepare("
            UPDATE projects
            SET designer_id=?, designer_name=?, status='AssignedToDesigner'
            WHERE id=?
        ")->execute([$designer_id,$designer_name,$project_id]);

        $pdo->prepare("
            INSERT INTO project_actions
            (project_id, action_by, action)
            VALUES (?,?,?)
        ")->execute([
            $project_id,
            'Design Manager',
            "Project assigned to designer: $designer_name"
        ]);
    }
}

/* ===============================
   FETCH PROJECTS
================================ */
$projects = $pdo->query("
    SELECT * FROM projects
    WHERE status='SentToDesigner'
    ORDER BY created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);

/* ===============================
   DESIGNERS
================================ */
$designers = $pdo->query("
    SELECT id, full_name
    FROM design_employees
    WHERE status = 1
    ORDER BY full_name ASC
")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
<title>Design Manager Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.card{border-radius:0}
</style>
</head>
<body>

<div class="container mt-4">
<h3>Projects Sent To Designer</h3>

<?php if(!$projects): ?>
<div class="alert alert-info">No projects available</div>
<?php endif; ?>

<?php foreach($projects as $p): ?>
<div class="card mb-4">
<div class="card-header bg-primary text-white">
<?= htmlspecialchars($p['title']) ?>
</div>

<div class="card-body">
<div class="row">
<div class="col-md-6">
<b>Client:</b> <?= htmlspecialchars($p['client_name']) ?><br>
<b>Price:</b> <?= $p['price'] ?><br>
<b>Sales:</b> <?= htmlspecialchars($p['sales_name']) ?>
</div>

<div class="col-md-6">
<b>Description</b><br>
<?= nl2br(htmlspecialchars($p['description'])) ?>
</div>
</div>

<hr>

<form method="POST" class="row g-2 align-items-end">
<input type="hidden" name="project_id" value="<?= $p['id'] ?>">

<div class="col-md-8">
<label>Select Designer</label>
<select name="designer_id" class="form-select" required>
<option value="">-- Select Designer --</option>
<?php foreach($designers as $d): ?>
<option value="<?= $d['id'] ?>"><?= htmlspecialchars($d['full_name']) ?></option>
<?php endforeach; ?>
</select>
</div>

<div class="col-md-4">
<button name="assign" class="btn btn-success w-100">
Assign Designer
</button>
</div>
</form>

</div>
</div>
<?php endforeach; ?>

</div>
</body>
</html>
