<?php
session_start();
require 'config/db.php';
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit;
}
if (!isset($_GET['id'])) die('Manager ID missing');

$id = intval($_GET['id']);
$error = '';
$success = '';

$stmt = $pdo->prepare("SELECT * FROM managers WHERE id=?");
$stmt->execute([$id]);
$manager = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$manager) die('Manager not found');

if ($_POST) {
    $full_name = $_POST['full_name'];
    $email = $_POST['email'];
    $department = $_POST['department'];
    $designation = $_POST['designation'];

    if (!$full_name || !$email || !$department || !$designation) {
        $error = "All fields are required";
    } else {
        $stmt = $pdo->prepare("
            UPDATE managers
            SET full_name=?, email=?, department=?, designation=?
            WHERE id=?
        ");
        $stmt->execute([$full_name, $email, $department, $designation, $id]);
        $success = "Manager updated successfully";

        $stmt = $pdo->prepare("SELECT * FROM managers WHERE id=?");
        $stmt->execute([$id]);
        $manager = $stmt->fetch(PDO::FETCH_ASSOC);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="../assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">

<style>
:root{
  
  --glass:rgba(255,255,255,.08);
}

*{margin:0;padding:0;box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}
body{background:var(--dark);color:#fff;min-height:100vh;overflow-x:hidden}

/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

/* Grid */
.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}
@keyframes grid{to{transform:translateY(70px)}}

/* Glass navbar */
.glass-navbar{
    background:var(--glass);
    backdrop-filter:blur(18px);
    border-radius:18px;
    border:1px solid rgba(255,255,255,0.2);
    box-shadow:0 10px 35px rgba(0,0,0,0.3);
    padding:14px 24px;
    margin-bottom:30px;
}

/* Glass form panel */
.glass-panel{
    background:var(--glass);
    backdrop-filter:blur(22px);
    border-radius:20px;
    border:1px solid rgba(255,255,255,0.2);
    box-shadow:0 12px 35px rgba(0,0,0,0.25);
    padding:28px;
}

/* Inputs */
.form-control, .form-select{
    background:rgba(0,0,0,.35);
    border:1px solid rgba(255,255,255,.15);
    color:#fff;
}
.form-control:focus, .form-select:focus{
    border-color:var(--blue);
    box-shadow:0 0 0 1px var(--blue),0 0 18px rgba(0,151,252,.45);
    background:rgba(0,0,0,.4);
    color:#fff;
}

/* Labels */
label{
    font-size:13px;
    opacity:.8;
}

/* Buttons */
.btn-main{
    background:linear-gradient(135deg,var(--blue),var(--orange));
    border:none;
    color:#fff;
    padding:12px;
    font-weight:600;
    width:100%;
    box-shadow:0 0 25px rgba(0,151,252,.4);
    transition:.3s;
}
.btn-main:hover{
    transform:translateY(-2px);
    box-shadow:0 0 35px rgba(255,138,0,.6);
}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<?php include '../assets/header.php'; ?>
<!-- ===== FORM PANEL ===== -->
<div class="container mt-4">
<div class="row justify-content-center">
<div class="col-lg-6">
<br><br><br>
<div class="glass-panel">
<h4 class="mb-3"><i class="fa-solid fa-user-pen text-warning"></i> Edit Manager</h4>

<?php if($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>
<?php if($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>

<form method="POST">

<div class="mb-3">
<label>Full Name</label>
<input type="text" name="full_name" class="form-control"
       value="<?= htmlspecialchars($manager['full_name']) ?>" required>
</div>

<div class="mb-3">
<label>Email</label>
<input type="email" name="email" class="form-control"
       value="<?= htmlspecialchars($manager['email']) ?>" required>
</div>

<div class="mb-3">
<label>Department</label>
<select name="department" class="form-select" required>
    <option value="">Select Department</option>
    <option value="Sales" <?= $manager['department']=='Sales'?'selected':'' ?>>Sales</option>
    <option value="Design" <?= $manager['department']=='Design'?'selected':'' ?>>Design</option>
    <option value="Development" <?= $manager['department']=='Development'?'selected':'' ?>>Development</option>
    <option value="Marketing" <?= $manager['department']=='Marketing'?'selected':'' ?>>Marketing</option>
</select>
</div>

<div class="mb-4">
<label>Designation</label>
<input type="text" name="designation" class="form-control"
       value="<?= htmlspecialchars($manager['designation']) ?>" required>
</div>

<button class="btn-main"><i class="fa-solid fa-save"></i> Update Manager</button>
</form>
</div>

</div>
</div>
</div>
<script src="../assets/particles.js"></script>
</body>
</html>
