<?php
session_start();
require 'config/db.php';

if(!isset($_SESSION['admin_id'])) die("Unauthorized");

$q=$pdo->query("
SELECT a.*,u.full_name
FROM marketing_ads_daily a
JOIN marketing_employees u ON u.id=a.employee_id
WHERE a.manager_status='approved'
AND a.admin_status='pending'
ORDER BY a.entry_date
");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>JG - Marketing Ads Approval</title>
<link rel="icon" type="image/png" href="images/jg.webp">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
:root{
  --glass:rgba(255,255,255,.08);
}

*{margin:0;padding:0;box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}
body{background:var(--dark);color:#fff;min-height:100vh;overflow-x:auto}

/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

/* Grid */
.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}
@keyframes grid{to{transform:translateY(70px)}}

/* ===== Topbar ===== */
.topbar{
  position:fixed;
  top:0;left:0;right:0;
  height:64px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:0 36px;
  background:rgba(8,12,25,.6);
  backdrop-filter:blur(14px);
  border-bottom:1px solid rgba(255,255,255,.06);
  z-index:10;
}
.logo{display:flex;align-items:center;font-weight:600;font-size:1.2rem;}
.status{font-size:13px;display:flex;align-items:center;gap:8px;}
.status::before{
  content:"";
  width:9px;height:9px;
  background:#1cff7a;
  border-radius:50%;
  box-shadow:0 0 12px #1cff7a;
}

/* ===== Glass Panel ===== */
.glass-panel{
  max-width:1200px;
  margin:110px auto 40px;
  padding:28px;
  background:var(--glass);
  backdrop-filter:blur(22px);
  border:1px solid rgba(255,255,255,.14);
  border-radius:18px;
  box-shadow:0 0 50px rgba(31,140,255,.3);
  overflow-x:auto;
}

/* Table Styling */
table{width:100%;border-collapse:collapse;color:#fff}
th,td{padding:10px;border:1px solid rgba(255,255,255,.2);text-align:left}
th{background:rgba(8,12,25,.8)}
tr:nth-child(even){background:rgba(255,255,255,.03)}
textarea{width:100%;background:rgba(0,0,0,.35);border:1px solid rgba(255,255,255,.15);color:#fff;padding:6px;border-radius:4px;resize:none}
button{padding:6px 12px;border:none;border-radius:4px;font-weight:600;cursor:pointer;transition:.3s}
button[name="action"][value="approve"]{background:linear-gradient(135deg,#1cff7a,#0d6efd);color:#fff}
button[name="action"][value="reject"]{background:linear-gradient(135deg,#ff4c4c,#ff8800);color:#fff}
button:hover{transform:translateY(-2px);box-shadow:0 0 12px rgba(31,140,255,.4)}
a{color:#1cff7a;text-decoration:underline}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ===== SAME MASTER HEADER ===== -->
<?php include 'assets/header.php'; ?>

<div class="glass-panel">
<h3 class="mb-4">Marketing Ads Pending Admin Approval</h3>

<table>
<tr>
<th>Emp</th><th>Date</th><th>Campaign</th>
<th>Spent</th><th>Leads</th><th>Proof</th><th>Action</th>
</tr>

<?php foreach($q as $r){ ?>
<tr>
<td><?=$r['full_name']?></td>
<td><?=$r['entry_date']?></td>
<td><?=$r['campaign_name']?></td>
<td><?=$r['budget_spent']?></td>
<td><?=$r['leads']?></td>

<td>
<?php
$p=$pdo->prepare("SELECT * FROM marketing_ads_proofs WHERE ads_id=?");
$p->execute([$r['id']]);
foreach($p as $f){
echo "<a target='_blank' href='../../employees/marketing/".$f['file_path']."'>View</a><br>";
}
?>
</td>

<td>
<form method="post" action="ads_admin_action.php" class="d-flex flex-column gap-2">
<input type="hidden" name="id" value="<?=$r['id']?>">
<textarea name="remark" placeholder="Enter remark" rows="2"></textarea>
<div class="d-flex gap-2">
<button name="action" value="approve">Final Approve</button>
<button name="action" value="reject">Reject</button>
</div>
</form>
</td>
</tr>
<?php } ?>
</table>
</div>

<script src="assets/particles.js"></script>
</body>
</html>
