<?php
session_start();
require '../config/db.php';

if(!isset($_SESSION['employee_id'])) die('Unauthorized');

$designer_id = $_SESSION['employee_id'];

/* ===============================
   FILE UPLOAD (DESIGN)
================================ */
if(isset($_POST['upload_design'])){
    $project_id = $_POST['project_id'];

    foreach($_FILES['design_files']['name'] as $i => $name){
        if($_FILES['design_files']['error'][$i]==0){
            $tmp  = $_FILES['design_files']['tmp_name'][$i];
            $file = time().'_'.$name;
            move_uploaded_file($tmp,"../uploads/designs/".$file);

            $pdo->prepare("
                INSERT INTO project_files
                (project_id, uploaded_by, file_stage, file_path)
                VALUES (?,?,?,?)
            ")->execute([
                $project_id,
                'Designer',
                'Design',
                $file
            ]);
        }
    }

    $pdo->prepare("
        UPDATE projects
        SET status='DesignUploaded'
        WHERE id=?
    ")->execute([$project_id]);

    $pdo->prepare("
        INSERT INTO project_actions
        (project_id, action_by, action)
        VALUES (?,?,?)
    ")->execute([
        $project_id,
        'Designer',
        'Design files uploaded'
    ]);

    header("Location: designer_dashboard.php?uploaded=1");
    exit;
}

/* ===============================
   FETCH ASSIGNED PROJECTS
================================ */
$stmt = $pdo->prepare("
    SELECT * FROM projects
    WHERE designer_id=? 
    AND status='AssignedToDesigner'
    ORDER BY created_at DESC
");
$stmt->execute([$designer_id]);
$projects = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* ===== PAGE TITLE ===== */
$page_title = "Designer • Assigned Projects";

/* ===== LAYOUT START ===== */
include 'assets/layout_top.php';
?>

<br><br><br>

<h3 class="text-center mb-4">
  <i class="fa-solid fa-layer-group me-2"></i>
  My Assigned Projects
</h3>

<?php if(!$projects): ?>
<div class="glass-card text-center">
  <i class="fa-solid fa-circle-info fa-2x mb-2"></i>
  <p class="mb-0">No assigned projects</p>
</div>
<?php endif; ?>

<?php foreach($projects as $p): ?>
<div class="glass-card">

  <h5 class="mb-3">
    <i class="fa-solid fa-folder-open me-2"></i>
    <?= htmlspecialchars($p['title']) ?>
    <span class="badge bg-warning text-dark ms-2">Assigned</span>
  </h5>

  <div class="row mb-3">
    <div class="col-md-6">
      <p><b>Client:</b> <?= htmlspecialchars($p['client_name']) ?></p>
      <p><b>Sales:</b> <?= htmlspecialchars($p['sales_name']) ?></p>
    </div>
    <div class="col-md-6">
      <b>Description:</b><br>
      <?= nl2br(htmlspecialchars($p['description'])) ?>
    </div>
  </div>

  <hr>

  <!-- CLIENT FILES -->
  <h6>
    <i class="fa-solid fa-user me-1"></i>
    Client Files
  </h6>

  <?php
  $clientFiles = $pdo->prepare("
      SELECT * FROM project_files
      WHERE project_id=? AND uploaded_by='Sales' AND file_stage='Client'
  ");
  $clientFiles->execute([$p['id']]);

  if($clientFiles->rowCount()==0){
      echo "<div class='text-muted'>No client files</div>";
  }

  foreach($clientFiles as $f):
  ?>
    <div class="file-box mb-1">
      <a href="../uploads/projects/<?= htmlspecialchars($f['file_path']) ?>" target="_blank">
        <i class="fa-solid fa-file-lines me-1"></i>
        <?= htmlspecialchars($f['file_path']) ?>
      </a>
    </div>
  <?php endforeach; ?>

  <hr>

  <!-- PAYMENT FILES -->
  <h6>
    <i class="fa-solid fa-credit-card me-1"></i>
    Payment Screenshots
  </h6>

  <?php
  $paymentFiles = $pdo->prepare("
      SELECT * FROM project_files
      WHERE project_id=? AND uploaded_by='Sales' AND file_stage='Payment'
  ");
  $paymentFiles->execute([$p['id']]);

  if($paymentFiles->rowCount()==0){
      echo "<div class='text-muted'>No payment proof uploaded</div>";
  }

  foreach($paymentFiles as $f):
  ?>
    <div class="file-box border-success mb-1">
      <a href="../uploads/payments/<?= htmlspecialchars($f['file_path']) ?>" target="_blank">
        <i class="fa-solid fa-file-invoice-dollar me-1"></i>
        <?= htmlspecialchars($f['file_path']) ?>
      </a>
    </div>
  <?php endforeach; ?>

  <hr>

  <!-- DESIGN UPLOAD -->
  <h6>
    <i class="fa-solid fa-cloud-arrow-up me-1"></i>
    Upload Design Files
  </h6>

  <form method="POST" enctype="multipart/form-data">
    <input type="hidden" name="project_id" value="<?= $p['id'] ?>">
    <input type="file" name="design_files[]" multiple required class="form-control mb-3">
    <button name="upload_design" class="btn-main">
      Upload Design
    </button>
  </form>

</div>
<?php endforeach; ?>

<?php
/* ===== LAYOUT END ===== */
include 'assets/layout_bottom.php';
?>
