<?php
session_start();
require '../config/db.php';

if(!isset($_SESSION['hr_id'])) die('Unauthorized');

$departments = ['sales','design','development','marketing'];
$statuses = ['Pending','Approved','Rejected'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="../assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
:root{
  --blue:#1f8cff;
  --orange:#ff8a00;
  --dark:#050814;
  --glass:rgba(255,255,255,.08);
}

*{box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}

body{
  background:var(--dark);
  color:#fff;
  min-height:100vh;
  overflow-x:hidden;
}

/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 30%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 30s ease-in-out infinite alternate;
  z-index:-5;
}
@keyframes mesh{to{filter:hue-rotate(25deg)}}

.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-4;
}
@keyframes grid{to{transform:translateY(70px)}}

/* ===== Top Bar ===== */
.topbar{
  position:fixed;top:0;left:0;right:0;
  height:64px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:0 32px;
  background:rgba(8,12,25,.6);
  backdrop-filter:blur(16px);
  border-bottom:1px solid rgba(255,255,255,.08);
  z-index:10;
}
.logo{
  font-weight:600;
  letter-spacing:.3px;
}
.status{
  font-size:13px;
  display:flex;
  align-items:center;
  gap:8px;
}
.status::before{
  content:"";
  width:9px;height:9px;
  background:#1cff7a;
  border-radius:50%;
  box-shadow:0 0 12px #1cff7a;
}

/* ===== Glass Container ===== */
.glass-panel{
  margin:100px 28px 40px;
  padding:28px;
  background:var(--glass);
  backdrop-filter:blur(22px);
  border:1px solid rgba(255,255,255,.15);
  border-radius:20px;
  box-shadow:0 0 60px rgba(31,140,255,.25);
}

/* ===== Tabs ===== */
.nav-tabs,.nav-pills{
  border-bottom:none;
}
.nav-link{
  color:#ccc;
  background:rgba(255,255,255,.05);
  border:none;
  margin-right:6px;
  border-radius:12px;
}
.nav-link.active{
  background:linear-gradient(135deg,var(--blue),var(--orange));
  color:#fff;
  box-shadow:0 0 18px rgba(31,140,255,.6);
}

/* ===== Cards ===== */
.card{
  background:rgba(255,255,255,.06);
  backdrop-filter:blur(16px);
  border:1px solid rgba(255,255,255,.14);
  border-radius:18px;
  color:#fff;
  box-shadow:0 0 30px rgba(0,0,0,.5);
}

/* ===== Chat ===== */
.chat-box{
  background:rgba(0,0,0,.35);
  padding:10px;
  border-radius:10px;
  font-size:14px;
  margin-bottom:10px;
  max-height:140px;
  overflow:auto;
}
.chat-hr{color:#6ec1ff}
.chat-manager{color:#ffb36e}

/* ===== Buttons ===== */
.btn{
  border:none;
  box-shadow:0 0 18px rgba(31,140,255,.4);
}
.btn-success{background:linear-gradient(135deg,#22c55e,#16a34a)}
.btn-danger{background:linear-gradient(135deg,#ef4444,#b91c1c)}
.btn-secondary{background:rgba(255,255,255,.15)}

.badge-count{
  margin-left:6px;
  box-shadow:0 0 10px rgba(255,0,0,.6);
}
</style>
</head>

<body>


<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<?php include '../assets/header.php'; ?>
<!-- ===== CONTENT ===== -->
<div class="glass-panel">

<h4 class="mb-4">Manager Leave Requests</h4>

<ul class="nav nav-tabs mb-4">
<?php foreach($departments as $i=>$dept): ?>
<li class="nav-item">
<button class="nav-link <?= $i==0?'active':'' ?>" data-bs-toggle="tab" data-bs-target="#dept-<?= $dept ?>">
<?= ucfirst($dept) ?>
</button>
</li>
<?php endforeach; ?>
</ul>

<div class="tab-content">

<?php foreach($departments as $i=>$dept): ?>
<div class="tab-pane fade <?= $i==0?'show active':'' ?>" id="dept-<?= $dept ?>">

<ul class="nav nav-pills mb-3">
<?php foreach($statuses as $j=>$status):
$stmtCount=$pdo->prepare("SELECT COUNT(*) FROM {$dept}_manager_leaves WHERE status=?");
$stmtCount->execute([$status]);
$count=$stmtCount->fetchColumn();
?>
<li class="nav-item">
<button class="nav-link <?= $j==0?'active':'' ?>" data-bs-toggle="tab"
data-bs-target="#<?= $dept ?>-<?= strtolower($status) ?>">
<?= $status ?>
<?php if($count>0): ?><span class="badge bg-danger badge-count"><?= $count ?></span><?php endif; ?>
</button>
</li>
<?php endforeach; ?>
</ul>

<div class="tab-content">

<?php foreach($statuses as $j=>$status):
$stmt=$pdo->prepare("SELECT * FROM {$dept}_manager_leaves WHERE status=? ORDER BY requested_on DESC");
$stmt->execute([$status]);
$leaves=$stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="tab-pane fade <?= $j==0?'show active':'' ?>" id="<?= $dept ?>-<?= strtolower($status) ?>">

<?php if(!$leaves): ?>
<p class="text-white">No <?= strtolower($status) ?> requests</p>
<?php else: foreach($leaves as $l): ?>

<div class="card mb-4">
<div class="card-body">

<p><b>Manager ID:</b> <?= $l['manager_id'] ?></p>
<p><b>Leave Date:</b> <?= $l['leave_date'] ?></p>
<p><b>Reason:</b> <?= htmlspecialchars($l['reason']) ?></p>

<div class="chat-box">
<?php
$msgTable=$dept.'_manager_leave_messages';
$msgs=$pdo->prepare("SELECT * FROM $msgTable WHERE leave_id=? ORDER BY created_at ASC");
$msgs->execute([$l['id']]);
if(!$msgs->rowCount()){
echo "<span class='text-white'>No messages</span>";
}else{
foreach($msgs as $m){
$cls=$m['sender']=='HR'?'chat-hr':'chat-manager';
echo "<div class='$cls'><b>{$m['sender']}:</b> ".htmlspecialchars($m['message'])."</div>";
}}
?>
</div>

<?php if($status=='Pending'): ?>
<form method="POST" action="hr_manager_leave_action.php" class="d-flex gap-2 mb-2">
<input type="hidden" name="leave_id" value="<?= $l['id'] ?>">
<input type="hidden" name="dept" value="<?= $dept ?>">
<input type="text" name="message" maxlength="25" class="form-control bg-dark text-white border-0"
placeholder="Reply (25 chars)" required>
<button name="send" class="btn btn-secondary btn-sm">Send</button>
</form>

<form method="POST" action="hr_manager_leave_action.php">
<input type="hidden" name="leave_id" value="<?= $l['id'] ?>">
<input type="hidden" name="dept" value="<?= $dept ?>">
<button name="approve" class="btn btn-success btn-sm">Approve</button>
<button name="reject" class="btn btn-danger btn-sm">Reject</button>
</form>
<?php else: ?>
<span class="badge bg-<?= $status=='Approved'?'success':'danger' ?>"><?= $status ?></span>
<?php endif; ?>

</div>
</div>

<?php endforeach; endif; ?>

</div>
<?php endforeach; ?>

</div>
</div>
<?php endforeach; ?>

</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="../assets/particles.js"></script>
</body>
</html>
