<?php
require '../config/auth.php';
require '../config/db.php';

$currentMonth = date('Y-m');

$employee_tables = [
    'Sales' => 'sales_employees',
    'Design' => 'design_employees',
    'Development' => 'development_employees',
    'Marketing' => 'marketing_employees'
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">

<style>
/* ========= ROOT (SAME SYSTEM THEME) ========= */
:root{
  --blue:#0097fc;
  --orange:#ff6a00;
  --dark:#050814;
  --glass:rgba(255,255,255,.08);
  --glowBlue:rgba(0,151,252,.6);
}

*{margin:0;padding:0;box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}

html,body{
  width:100%;
  height:100%;
  background:var(--dark);
  color:#fff;
  overflow-x:hidden;
}

/* ========= BACKGROUND ========= */
.mesh{
  position:fixed; inset:0;
  background:
    radial-gradient(circle at 20% 20%, rgba(0,151,252,.35), transparent 45%),
    radial-gradient(circle at 80% 30%, rgba(255,106,0,.3), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:0;
}
@keyframes mesh{from{filter:hue-rotate(0)}to{filter:hue-rotate(25deg)}}

.grid{
  position:fixed; inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:1;
}
@keyframes grid{from{transform:translateY(0)}to{transform:translateY(70px)}}

#particles{position:fixed;inset:0;z-index:2}

/* ========= TOPBAR ========= */
.topbar{
  position:fixed;
  top:0;left:0;right:0;
  height:64px;
  padding:0 36px;
  display:flex;
  justify-content:space-between;
  align-items:center;
  background:rgba(8,12,25,.6);
  backdrop-filter:blur(14px);
  border-bottom:1px solid rgba(255,255,255,.08);
  z-index:10;
}
.logo{display:flex;align-items:center;gap:10px;font-weight:600}
.logo img{height:45px}
.logo span{color:var(--blue)}
.status{font-size:13px;display:flex;align-items:center;gap:8px}
.status::before{
  content:"";
  width:9px;height:9px;
  background:#1cff7a;
  border-radius:50%;
  box-shadow:0 0 12px #1cff7a;
}

/* ========= CONTENT ========= */
.page{
  position:relative;
  z-index:5;
  padding:100px 24px 40px;
}

.glass-box{
  background:var(--glass);
  backdrop-filter:blur(20px);
  border:1px solid rgba(255,255,255,.14);
  border-radius:18px;
  box-shadow:0 0 45px var(--glowBlue);
  padding:20px;
  margin-bottom:40px;
}

.table-wrapper{
  max-height:420px;
  overflow:auto;
  border-radius:14px;
}

.table thead th{
  background:rgba(0,0,0,.6);
  color:#9ad1ff;
  position:sticky;
  top:0;
  z-index:2;
  border:none;
}

.table td{
  background:rgba(255,255,255,.05);
  border:none;
  color:#fff;
  font-size:13px;
}

.table tr:hover td{
  background:rgba(0,151,252,.08);
}

/* KPI */
.kpi{
  padding:6px 12px;
  border-radius:999px;
  background:linear-gradient(135deg,var(--blue),var(--orange));
  box-shadow:0 0 16px var(--glowBlue);
  font-weight:600;
}

/* Buttons */
.btn-glow{
  background:linear-gradient(135deg,var(--blue),var(--orange));
  border:none;color:#fff;
  box-shadow:0 0 20px var(--glowBlue);
}
.btn-glow:hover{transform:translateY(-2px)}

.btn-edit{
  background:linear-gradient(135deg,#1f8cff,#33cfff);
  border:none;color:#fff;
}
.btn-delete{
  background:linear-gradient(135deg,#ff3b3b,#ff8a00);
  border:none;color:#fff;
}
</style>
</head>

<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<div class="topbar">
  <div class="logo">
    <img src="images/jg.webp">
    Jillion <span>Gamuts</span>
  </div>
  <div class="d-flex align-items-center gap-3">
    <a href="index.php" class="btn btn-sm btn-outline-light">Dashboard</a>
    <div class="status">System Online</div>
  </div>
</div>

<div class="page">
  <a href="create_employee.php" class="btn btn-glow mb-4">
    <i class="fa fa-plus"></i> Add Employee
  </a>

<?php foreach($employee_tables as $dept=>$table):

$stmt=$pdo->prepare("
SELECT e.*,
(
 SELECT COUNT(DISTINCT login_date)
 FROM {$table}_login_logs l
 WHERE l.employee_id=e.id
 AND DATE_FORMAT(l.login_date,'%Y-%m')=?
) monthly_logins
FROM $table e ORDER BY e.full_name
");
$stmt->execute([$currentMonth]);
$employees=$stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="glass-box">
<h4 class="mb-3"><i class="fa fa-users text-warning"></i> <?= $dept ?> Department</h4>

<div class="table-wrapper">
<table class="table table-sm align-middle">
<thead>
<tr>
<th>ID</th><th>Name</th><th>Email</th><th>Phone</th>
<th>Designation</th><th>Joining</th><th>Salary</th>
<th>Last Login</th><th>IP</th><th>Monthly</th><th>Actions</th>
</tr>
</thead>
<tbody>

<?php foreach($employees as $emp):
$log_table=$table.'_login_logs';
$q=$pdo->prepare("SELECT login_date,login_time,ip_address FROM $log_table WHERE employee_id=? ORDER BY id DESC LIMIT 1");
$q->execute([$emp['id']]);
$last=$q->fetch(PDO::FETCH_ASSOC);
?>
<tr>
<td><?= $emp['id'] ?></td>
<td><?= htmlspecialchars($emp['full_name']) ?></td>
<td><?= htmlspecialchars($emp['email']) ?></td>
<td><?= $emp['phone'] ?></td>
<td><?= $emp['designation'] ?></td>
<td><?= $emp['joining_date'] ?></td>
<td><?= $emp['basic_salary'] ?></td>
<td><?= $last['login_date'] ?? '-' ?> <?= $last['login_time'] ?? '' ?></td>
<td><?= $last['ip_address'] ?? '-' ?></td>
<td><span class="kpi"><?= $emp['monthly_logins'] ?></span></td>
<td>
<a href="edit_employee.php?table=<?= $table ?>&id=<?= $emp['id'] ?>" class="btn btn-edit btn-sm"><i class="fa fa-pen"></i></a>
<a href="delete_employee.php?table=<?= $table ?>&id=<?= $emp['id'] ?>" class="btn btn-delete btn-sm" onclick="return confirm('Delete?')"><i class="fa fa-trash"></i></a>
</td>
</tr>
<?php endforeach; ?>

</tbody>
</table>
</div>
</div>

<?php endforeach; ?>
</div>

<script>
const canvas = document.getElementById("particles");
const ctx = canvas.getContext("2d");

let w = canvas.width = window.innerWidth;
let h = canvas.height = window.innerHeight;

window.addEventListener("resize",()=>{
  w = canvas.width = window.innerWidth;
  h = canvas.height = window.innerHeight;
});

class Particle{
  constructor(){
    this.x=Math.random()*w;
    this.y=Math.random()*h;
    this.size=Math.random()*3+1;
    this.vx=(Math.random()-0.5)*1.2;
    this.vy=(Math.random()-0.5)*1.2;
    this.color=Math.random()>.5?"#0097fc":"#ff6a00";
  }
  draw(){
    ctx.beginPath();
    ctx.arc(this.x,this.y,this.size,0,Math.PI*2);
    ctx.fillStyle=this.color;
    ctx.fill();
  }
  update(){
    this.x+=this.vx;
    this.y+=this.vy;
    if(this.x<0||this.x>w) this.vx*=-1;
    if(this.y<0||this.y>h) this.vy*=-1;
  }
}

const particles=[];
for(let i=0;i<120;i++) particles.push(new Particle());

function connect(){
  for(let a=0;a<particles.length;a++){
    for(let b=a;b<particles.length;b++){
      const dx=particles[a].x-particles[b].x;
      const dy=particles[a].y-particles[b].y;
      const d=Math.sqrt(dx*dx+dy*dy);
      if(d<120){
        ctx.strokeStyle="rgba(0,151,252,.2)";
        ctx.lineWidth=1;
        ctx.beginPath();
        ctx.moveTo(particles[a].x,particles[a].y);
        ctx.lineTo(particles[b].x,particles[b].y);
        ctx.stroke();
      }
    }
  }
}

(function animate(){
  ctx.clearRect(0,0,w,h);
  particles.forEach(p=>{p.update();p.draw();});
  connect();
  requestAnimationFrame(animate);
})();
</script>

</body>
</html>
