<?php
session_start();
require '../config/db.php';
if(!isset($_SESSION['hr_id'])) die('Unauthorized');

$requests = $pdo->query(
  "SELECT * FROM design_attendance_requests ORDER BY created_at DESC"
)->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="../assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

</head>

<body>

<!-- ===== BACKGROUND ===== -->
<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ===== SAME MASTER HEADER ===== -->
<?php include '../assets/header.php'; ?>

<!-- ===== CONTENT ===== -->
<div class="container-fluid" style="padding-top:90px">

  <div class="glass-box">

    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4 class="mb-0">
        Attendance Requests
      </h4>
      <span class="badge bg-dark">HR Panel</span>
    </div>

    <div class="table-responsive" style="max-height:420px">
      <table class="table table-bordered table-hover table-sm align-middle text-white">
        <thead style="background:rgba(0,0,0,.55)">
          <tr>
            <th>Employee ID</th>
            <th>Department</th>
            <th>Date</th>
            <th>Reason</th>
            <th>Status</th>
            <th style="width:160px">Action</th>
          </tr>
        </thead>
        <tbody>

        <?php foreach($requests as $r): ?>
          <tr>
            <td><?= $r['employee_id'] ?></td>
            <td><?= $r['department'] ?></td>
            <td><?= $r['req_date'] ?></td>
            <td><?= htmlspecialchars($r['reason']) ?></td>
            <td>
              <span class="badge 
                <?= $r['status']=='Pending'?'bg-warning text-dark':'bg-secondary' ?>">
                <?= $r['status'] ?>
              </span>
            </td>
            <td>
              <?php if($r['status']=='Pending'): ?>
              <form method="POST" action="approve_attendance_request.php" class="d-flex gap-1">
                <input type="hidden" name="id" value="<?= $r['id'] ?>">
                <button name="action" value="approve" class="btn btn-success btn-sm">
                  Approve
                </button>
                <button name="action" value="reject" class="btn btn-danger btn-sm">
                  Reject
                </button>
              </form>
              <?php else: ?>
                <span class="text-muted">—</span>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>

        </tbody>
      </table>
    </div>

  </div>

</div>
<script src="../assets/particles.js"></script>
</body>
</html>
