<?php
session_start();
require 'config/db.php';

if(!isset($_SESSION['employee_id'])) die('Unauthorized');

$msg = '';

if(isset($_POST['submit'])){

    /* ===============================
       SAFE INPUTS
    ================================ */
    $price            = floatval($_POST['price']);
    $payment_received = floatval($_POST['payment_received']);

    if($payment_received > $price){
        die('Payment received cannot be greater than project price');
    }

    $payment_remaining = $price - $payment_received;
    
    /* ===============================
       INSERT PROJECT
    ================================ */
    $stmt = $pdo->prepare("
        INSERT INTO projects (
            sales_id, sales_name,
            client_name, client_email, client_phone,
            title, description,
            price, payment_received, payment_remaining,
            deadline,
            status
        ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)
    ");
    $stmt->execute([
        $_SESSION['employee_id'],
        $_SESSION['employee_name'],
        $_POST['client_name'],
        $_POST['client_email'],
        $_POST['client_phone'],
        $_POST['title'],
        $_POST['description'],
        $price,
        $payment_received,
        $payment_remaining,
        $_POST['deadline'],
        'Pending'
    ]);

    $project_id = $pdo->lastInsertId();

    /* ===============================
       CLIENT FILES
    ================================ */
    if(!empty($_FILES['client_files']['name'][0])){
        foreach($_FILES['client_files']['name'] as $k => $name){
            if($_FILES['client_files']['error'][$k] == 0){
                $fname = time().'_'.$name;
                move_uploaded_file(
                    $_FILES['client_files']['tmp_name'][$k],
                    "../uploads/projects/".$fname
                );

                $pdo->prepare("
                    INSERT INTO project_files
                    (project_id, uploaded_by, file_stage, file_path)
                    VALUES (?,?,?,?)
                ")->execute([
                    $project_id,
                    'Sales',
                    'Client',
                    $fname
                ]);
            }
        }
    }

    /* ===============================
       PAYMENT SCREENSHOT
    ================================ */
    if(!empty($_FILES['payment_file']['name'])){
        $payFile = 'pay_'.time().'_'.$_FILES['payment_file']['name'];
        move_uploaded_file(
            $_FILES['payment_file']['tmp_name'],
            "../uploads/payments/".$payFile
        );

        $pdo->prepare("
            INSERT INTO project_files
            (project_id, uploaded_by, file_stage, file_path)
            VALUES (?,?,?,?)
        ")->execute([
            $project_id,
            'Sales',
            'Payment',
            $payFile
        ]);
    }

    /* ===============================
       ACTION LOG
    ================================ */
    $pdo->prepare("
        INSERT INTO project_actions
        (project_id, action_by, action)
        VALUES (?,?,?)
    ")->execute([
        $project_id,
        'Sales',
        'Project created. Payment received: '.$payment_received.
        ', Remaining: '.$payment_remaining
    ]);

    $msg = "Project added successfully and sent for admin approval";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="assets/style.css">

<style>
/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}

/* Glass form panel */
.glass-panel{
  max-width:700px;
  margin:60px auto;
  padding:30px;
  background:rgba(255,255,255,.08);
  backdrop-filter:blur(22px);
  border-radius:18px;
  border:1px solid rgba(255,255,255,.14);
  box-shadow:0 12px 35px rgba(0,151,252,.25);
  color:#fff;
}

/* Form inputs */
input.form-control, textarea.form-control{
  background:rgba(185, 185, 185, 0.35);
  border:1px solid rgba(255,255,255,.15);
  color:white;
}
input.form-control:focus, textarea.form-control:focus{
  border-color:#0097fc;
  box-shadow:0 0 0 1px #0097fc, 0 0 18px rgba(0,151,252,.45);
  background:rgba(202, 202, 202, 0.4);
}

/* Labels */
label{font-size:13px;opacity:.8;color:#fff}

/* Buttons */
.btn-main{
  background:linear-gradient(135deg,#0097fc,#ff6a00);
  border:none;
  color:#fff;
  font-weight:600;
  padding:12px;
  box-shadow:0 0 25px rgba(0,151,252,.4);
  transition:.3s;
}
.btn-main:hover{
  transform:translateY(-2px);
  box-shadow:0 0 35px rgba(255,138,0,.6);
}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ===== HEADER ===== -->
<?php include 'assets/header.php'; ?>
<br><br>
<div class="glass-panel">

<h3 class="mb-4 text-center">Add New Project</h3>

<?php if($msg): ?>
<div class="alert alert-success"><?= htmlspecialchars($msg) ?></div>
<?php endif; ?>

<form method="POST" enctype="multipart/form-data">

<h5>Client Information</h5>
<input class="form-control mb-2" name="client_name" placeholder="Client Name" required>
<input class="form-control mb-2" name="client_email" placeholder="Client Email">
<input class="form-control mb-2" name="client_phone" placeholder="Client Phone">

<hr>

<h5>Project Information</h5>
<input class="form-control mb-2" name="title" placeholder="Project Title" required>
<textarea class="form-control mb-2" name="description" placeholder="Project Description" required></textarea>

<input class="form-control mb-2" type="number" step="0.01" name="price" placeholder="Total Project Price" required>
<input class="form-control mb-2" type="number" step="0.01" name="payment_received" placeholder="Payment Received" required>
<label>Project Deadline</label>
<input class="form-control mb-2" type="date" name="deadline" required>

<hr>

<label>Client Files</label>
<input class="form-control mb-3" type="file" name="client_files[]" multiple>

<label>Payment Screenshot</label>
<input class="form-control mb-3" type="file" name="payment_file" required>

<button class="btn-main w-100" name="submit">Create Project</button>
</form>

</div>

<script src="assets/particles.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
