<?php
session_start();
require 'config/db.php';

if (!isset($_SESSION['employee_id'])) {
    die('Unauthorized');
}

$emp = $_SESSION['employee_id'];

// Fetch all leaves for this employee
$stmt = $pdo->prepare("
    SELECT *
    FROM employee_leave_requests
    WHERE employee_id = ?
    ORDER BY leave_date DESC
");
$stmt->execute([$emp]);
$leaves = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Separate leaves by status
$pending = array_filter($leaves, fn($l) => $l['status'] === 'Pending');
$managerApproved = array_filter($leaves, fn($l) => $l['status'] === 'ManagerApproved');
$hrApproved = array_filter($leaves, fn($l) => $l['status'] === 'HRApproved');
$Rejected = array_filter($leaves, fn($l) => $l['status'] === 'Rejected');
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- External CSS -->
<link rel="stylesheet" href="assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}
@keyframes grid{to{transform:translateY(70px)}}

/* Glass panel */
.glass-panel{
  max-width:900px;
  margin:80px auto;
  padding:30px;
  background:rgba(255,255,255,.08);
  backdrop-filter:blur(22px);
  border-radius:18px;
  border:1px solid rgba(255,255,255,.14);
  box-shadow:0 12px 35px rgba(0,151,252,.25);
  color:#fff;
}

/* Cards & messages */
.card{background:rgba(0,0,0,.35);border:none;color:#fff}
.chat-box{
  background:rgba(255,255,255,.05);
  border:1px solid rgba(255,255,255,.12);
  padding:10px;
  max-height:160px;
  overflow-y:auto;
  font-size:14px;
  border-radius:8px;
}
.msg-manager{color:#ff6a00}
.msg-employee{color:#1f8cff}
.badge-status{font-size:0.85rem}

/* Tabs */
.nav-tabs .nav-link.active{
  background:linear-gradient(135deg,#0097fc,#ff6a00);
  color:#fff;
  border:none;
  border-radius:8px;
}

/* Buttons */
.btn-main{
  background:linear-gradient(135deg,#0097fc,#ff6a00);
  border:none;
  color:#fff;
  font-weight:600;
  padding:6px 14px;
  box-shadow:0 0 25px rgba(0,151,252,.4);
  transition:.3s;
}
.btn-main:hover{
  transform:translateY(-2px);
  box-shadow:0 0 35px rgba(255,138,0,.6);
}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ===== HEADER ===== -->
<?php include 'assets/header.php'; ?>

<div class="glass-panel">

<h4 class="mb-4 text-center">My Leave Requests</h4>

<!-- TABS -->
<ul class="nav nav-tabs mb-3" id="leaveTab" role="tablist">
  <li class="nav-item" role="presentation">
    <button class="nav-link active" id="pending-tab" data-bs-toggle="tab" data-bs-target="#pending" type="button" role="tab">Pending</button>
  </li>
  <li class="nav-item" role="presentation">
    <button class="nav-link" id="manager-tab" data-bs-toggle="tab" data-bs-target="#manager" type="button" role="tab">Manager Approved</button>
  </li>
  <li class="nav-item" role="presentation">
    <button class="nav-link" id="hr-tab" data-bs-toggle="tab" data-bs-target="#hr" type="button" role="tab">HR Approved</button>
  </li>
  <li class="nav-item" role="presentation">
    <button class="nav-link" id="rejected-tab" data-bs-toggle="tab" data-bs-target="#rejected" type="button" role="tab">Rejected</button>
  </li>
</ul>

<div class="tab-content">

<!-- Function to render leaves -->
<?php
function renderLeaves($leaves, $pdo){
    if(!$leaves){
        echo '<div class="alert alert-info">No leaves.</div>';
        return;
    }
    foreach($leaves as $l){
        ?>
        <div class="card shadow-sm mb-4">
        <div class="card-body">

            <div class="d-flex justify-content-between align-items-center mb-2">
                <h5 class="mb-0">Leave Date: <?= htmlspecialchars($l['leave_date']) ?></h5>
                <span class="badge bg-warning badge-status"><?= htmlspecialchars($l['status']) ?></span>
            </div>

            <div class="alert alert-secondary p-2 mb-2">
                <strong>Reason:</strong><br><?= htmlspecialchars($l['reason']) ?>
            </div>

            <div class="chat-box mb-2">
            <?php
            $msgs = $pdo->prepare("SELECT * FROM leave_messages WHERE leave_id=? ORDER BY created_at");
            $msgs->execute([$l['id']]);
            if($msgs->rowCount()==0){ echo '<span class="text-white">No messages yet.</span>'; }
            else{
                foreach($msgs as $m){
                    $cls = $m['sender']=='Manager'?'msg-manager':'msg-employee';
                    echo "<div class='$cls'><b>{$m['sender']}:</b> ".htmlspecialchars($m['message'])."</div>";
                }
            }
            ?>
            </div>

            <?php if($l['status']=='Pending'): ?>
            <form method="POST" action="send_message.php" class="d-flex gap-2">
                <input type="hidden" name="leave_id" value="<?= $l['id'] ?>">
                <input type="text" name="message" class="form-control form-control-sm" maxlength="25" placeholder="Reply (max 25 chars)" required>
                <button class="btn-main">Send</button>
            </form>
            <?php endif; ?>

        </div>
        </div>
        <?php
    }
}
?>

<div class="tab-pane fade show active" id="pending" role="tabpanel">
    <?php renderLeaves($pending,$pdo); ?>
</div>

<div class="tab-pane fade" id="manager" role="tabpanel">
    <?php renderLeaves($managerApproved,$pdo); ?>
</div>

<div class="tab-pane fade" id="hr" role="tabpanel">
    <?php renderLeaves($hrApproved,$pdo); ?>
</div>

<div class="tab-pane fade" id="rejected" role="tabpanel">
    <?php renderLeaves($Rejected,$pdo); ?>
</div>

</div>
</div>

<script src="assets/particles.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
