<?php
session_start();
require 'config/db.php';

if (!isset($_SESSION['set_pass_id'])) {
    die('Access denied');
}

$error = '';

if ($_POST) {
    if ($_POST['password'] !== $_POST['confirm_password']) {
        $error = "Passwords do not match";
    } elseif (strlen($_POST['password']) < 6) {
        $error = "Password must be at least 6 characters";
    } else {
        $hash = password_hash($_POST['password'], PASSWORD_DEFAULT);

        $pdo->prepare("
            UPDATE managers
            SET password=?, must_change_password=0
            WHERE id=?
        ")->execute([$hash, $_SESSION['set_pass_id']]);

        unset($_SESSION['set_pass_id']);
        header("Location: login.php");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Set Password</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{
    background: linear-gradient(135deg, #232526, #414345);
}
.set-card{
    border: none;
    border-radius: 6px;
}
</style>
</head>

<body class="d-flex align-items-center vh-100">

<div class="container">
 <div class="row justify-content-center">
  <div class="col-md-4">

   <div class="card set-card shadow">
    <div class="card-body p-4">

     <h4 class="text-center mb-2">Set Your Password</h4>
     <p class="text-muted text-center" style="font-size:13px">
        First time login — please create a secure password
     </p>

     <?php if($error): ?>
      <div class="alert alert-danger"><?= $error ?></div>
     <?php endif; ?>

     <form method="POST" autocomplete="off">

      <div class="mb-3">
       <label class="form-label">New Password</label>
       <input type="password" name="password" class="form-control" required>
      </div>

      <div class="mb-3">
       <label class="form-label">Confirm Password</label>
       <input type="password" name="confirm_password" class="form-control" required>
      </div>

      <button class="btn btn-dark w-100">Save Password</button>

     </form>

    </div>
   </div>

  </div>
 </div>
</div>

</body>
</html>
