<?php
session_start();
require 'config/db.php';

if (!isset($_SESSION['manager_id'])) {
    die('Unauthorized');
}

$dept = 'Sales';
$dept = strtolower($_SESSION['department']);
$dept = preg_replace('/[^a-z0-9_]/','',$dept);

// Fetch Pending Leaves (Manager action required)
$pending_stmt = $pdo->prepare("
    SELECT r.*, e.full_name
    FROM employee_leave_requests r
    JOIN {$dept}_employees e ON r.employee_id = e.id
    WHERE r.status = 'Pending'
    ORDER BY r.created_at ASC
");
$pending_stmt->execute();
$pending_requests = $pending_stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch Manager Approved Leaves (HR action pending)
$hr_pending_stmt = $pdo->prepare("
    SELECT r.*, e.full_name
    FROM employee_leave_requests r
    JOIN {$dept}_employees e ON r.employee_id = e.id
    WHERE r.status = 'ManagerApproved'
    ORDER BY r.leave_date ASC
");
$hr_pending_stmt->execute();
$hr_pending_requests = $hr_pending_stmt->fetchAll(PDO::FETCH_ASSOC);

$hr_approve_stmt = $pdo->prepare("
    SELECT r.*, e.full_name
    FROM employee_leave_requests r
    JOIN {$dept}_employees e ON r.employee_id = e.id
    WHERE r.status = 'HRApproved'
    ORDER BY r.leave_date ASC
");
$hr_approve_stmt->execute();
$hr_approve_requests = $hr_approve_stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch Rejected Leaves
$rejected_stmt = $pdo->prepare("
    SELECT r.*, e.full_name
    FROM employee_leave_requests r
    JOIN {$dept}_employees e ON r.employee_id = e.id
    WHERE r.status = 'Rejected'
    ORDER BY r.leave_date DESC
");
$rejected_stmt->execute();
$rejected_requests = $rejected_stmt->fetchAll(PDO::FETCH_ASSOC);
include 'assets/layout_top.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
/* ===== DARK GLASS THEME ===== */

.navbar{
    background:#020617 !important;
}
.navbar-brand{color:#1f8cff;}
.container{max-width:1350px; margin:30px auto;}

/* Tabs */
.nav-tabs .nav-link{
    color:#cbd5e1;
    background:rgba(255,255,255,0.05);
    border:1px solid rgba(255,255,255,0.1);
    border-radius:10px 10px 0 0;
}
.nav-tabs .nav-link.active{
    color:#fff;
    background:rgba(31,140,255,0.15);
    border-color:#1f8cff #3d3d3d #020617;
}

/* Glass Cards */
.card{
    background:rgba(255,255,255,0.05);
    backdrop-filter:blur(10px);
    border-radius:18px;
    margin-bottom:26px;
     color:white;
    box-shadow:0 12px 30px rgba(0,0,0,.6);
    border:1px solid rgba(255,255,255,0.1);
}

/* Chat box */
.chat-box{
     color:white;
    background:rgba(255,255,255,0.05);
    border:1px solid rgba(255,255,255,0.1);
    padding:10px;
    max-height:180px;
    overflow-y:auto;
    font-size:14px;
    border-radius:12px;
}
.chat-employee{color:#22d3ee; font-weight:500;}
.chat-manager{color:#ef4444; font-weight:600;}

/* Inputs & Buttons */
input.form-control, button{
    background:rgba(255,255,255,0.05);
    border:1px solid rgba(255,255,255,0.1);
     color:white;
}
button{background:#1f8cff; color:white; cursor:pointer;}
button.btn-warning{background:#fbbf24;color:#020617;}
button.btn-success{background:#22c55e;color:#020617;}
button.btn-danger{background:#ef4444; color:white;}

/* Labels & Badges */
.badge.bg-danger{background:#ef4444;}

/* Scrollbar (chat) */
.chat-box::-webkit-scrollbar{
    width:6px;
     color:white;
}
.chat-box::-webkit-scrollbar-thumb{
    background:#1f8cff;
     color:white;
    border-radius:10px;
}

/* Alerts inside cards */
.alert-secondary{
    background:rgba(255,255,255,0.05);
    color:#e0e0e0;
    border:1px solid rgba(144, 144, 144, 0.1);
}
</style>
</head>
<body>
<br><br>
<nav class="navbar navbar-dark px-4">
    <span class="navbar-brand"><?= htmlspecialchars($dept) ?> Manager – Leave Requests</span>
   
</nav>

<div class="container mt-4">

<!-- Tabs -->
<ul class="nav nav-tabs mb-3" id="leaveTab" role="tablist">
  <li class="nav-item">
    <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#pending">Pending</button>
  </li>
  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#hr">HR Pending</button>
  </li>
  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#approve">Approved</button>
  </li>
  <li class="nav-item">
    <button class="nav-link text-danger" data-bs-toggle="tab" data-bs-target="#rejected">Rejected</button>
  </li>
</ul>

<div class="tab-content">

<!-- PENDING TAB -->
<div class="tab-pane fade show active" id="pending" role="tabpanel">
<?php if(!$pending_requests): ?>
    <div class="alert alert-info">No pending leave requests for your approval.</div>
<?php else: ?>
<?php foreach($pending_requests as $r): ?>
<div class="card shadow-sm mb-4">
<div class="card-body">
    <h5><?= htmlspecialchars($r['full_name']) ?></h5>
    <p class="text-white mb-1">
        Leave Date: <strong><?= htmlspecialchars($r['leave_date']) ?></strong>
    </p>
    <div class="alert alert-secondary p-2 mb-2">
        <strong>Reason:</strong><br><?= htmlspecialchars($r['reason']) ?>
    </div>

    <!-- Conversation -->
    <div class="chat-box mb-2">
    <?php
    $msgs = $pdo->prepare("SELECT * FROM leave_messages WHERE leave_id=? ORDER BY created_at ASC");
    $msgs->execute([$r['id']]);
    if($msgs->rowCount()==0){ echo '<span class="text-white">No conversation yet.</span>'; }
    else{
        foreach($msgs as $m){
            $cls = $m['sender']=='Manager' ? 'chat-manager' : 'chat-employee';
            echo "<div class='$cls'><b>{$m['sender']}:</b> ".htmlspecialchars($m['message'])."</div>";
        }
    }
    ?>
    </div>

    <!-- Ask Question -->
    <form method="POST" action="send_message.php" class="d-flex gap-2 mb-2">
        <input type="hidden" name="leave_id" value="<?= $r['id'] ?>">
        <input type="text" name="message" class="form-control form-control-sm"
               maxlength="25" placeholder="Ask (max 25 chars)" required>
        <button class="btn btn-warning btn-sm">Send</button>
    </form>

    <!-- Approve + Reject -->
    <div class="d-flex gap-2">
        <form method="POST" action="approve_leave.php"
              onsubmit="return confirm('Approve this leave and send to HR?')">
            <input type="hidden" name="id" value="<?= $r['id'] ?>">
            <button class="btn btn-success btn-sm">Approve</button>
        </form>
        <form method="POST" action="reject_leave.php"
              onsubmit="return confirm('Reject this leave request?')">
            <input type="hidden" name="id" value="<?= $r['id'] ?>">
            <button class="btn btn-danger btn-sm">Reject</button>
        </form>
    </div>

</div>
</div>
<?php endforeach; ?>
<?php endif; ?>
</div>

<!-- HR PENDING TAB -->
<div class="tab-pane fade" id="hr" role="tabpanel">
<?php if(!$hr_pending_requests): ?>
    <div class="alert alert-info">No leaves approved by you pending HR finalization.</div>
<?php else: ?>
    <?php foreach($hr_pending_requests as $r): ?>
    <div class="card shadow-sm mb-4">
    <div class="card-body">
        <h5><?= htmlspecialchars($r['full_name']) ?></h5>
        <p class="text-white mb-1">Leave Date: <strong><?= htmlspecialchars($r['leave_date']) ?></strong></p>
        <div class="alert alert-secondary p-2 mb-2"><?= htmlspecialchars($r['reason']) ?></div>
        <div class="chat-box mb-2">
        <?php
        $msgs = $pdo->prepare("SELECT * FROM leave_messages WHERE leave_id=? ORDER BY created_at ASC");
        $msgs->execute([$r['id']]);
        if($msgs->rowCount()==0){ echo '<span class="text-white">No conversation yet.</span>'; }
        else{
            foreach($msgs as $m){
                $cls = $m['sender']=='Manager'?'chat-manager':'chat-employee';
                echo "<div class='$cls'><b>{$m['sender']}:</b> ".htmlspecialchars($m['message'])."</div>";
            }
        }
        ?>
        </div>
    </div>
    </div>
    <?php endforeach; ?>
<?php endif; ?>
</div>

<!-- APPROVED TAB -->
<div class="tab-pane fade" id="approve" role="tabpanel">
<?php if(!$hr_approve_requests): ?>
    <div class="alert alert-info">No HR-approved leaves.</div>
<?php else: ?>
    <?php foreach($hr_approve_requests as $r): ?>
    <div class="card shadow-sm mb-4">
    <div class="card-body">
        <h5><?= htmlspecialchars($r['full_name']) ?></h5>
        <p class="text-white mb-1">Leave Date: <strong><?= htmlspecialchars($r['leave_date']) ?></strong></p>
        <div class="alert alert-secondary p-2 mb-2"><?= htmlspecialchars($r['reason']) ?></div>
        <div class="chat-box mb-2">
        <?php
        $msgs = $pdo->prepare("SELECT * FROM leave_messages WHERE leave_id=? ORDER BY created_at ASC");
        $msgs->execute([$r['id']]);
        if($msgs->rowCount()==0){ echo '<span class="text-white">No conversation yet.</span>'; }
        else{
            foreach($msgs as $m){
                $cls = $m['sender']=='Manager'?'chat-manager':'chat-employee';
                echo "<div class='$cls'><b>{$m['sender']}:</b> ".htmlspecialchars($m['message'])."</div>";
            }
        }
        ?>
        </div>
    </div>
    </div>
    <?php endforeach; ?>
<?php endif; ?>
</div>

<!-- REJECTED TAB -->
<div class="tab-pane fade" id="rejected" role="tabpanel">
<?php if(!$rejected_requests): ?>
    <div class="alert alert-info">No rejected leave requests.</div>
<?php else: ?>
<?php foreach($rejected_requests as $r): ?>
<div class="card shadow-sm mb-4 border-danger">
<div class="card-body">
    <h5><?= htmlspecialchars($r['full_name']) ?></h5>
    <p class="text-white mb-1">Leave Date: <strong><?= htmlspecialchars($r['leave_date']) ?></strong></p>
    <span class="badge bg-danger mb-2">Rejected</span>
    <div class="alert alert-secondary p-2 mb-2"><?= htmlspecialchars($r['reason']) ?></div>
    <div class="chat-box">
    <?php
    $msgs = $pdo->prepare("SELECT * FROM leave_messages WHERE leave_id=? ORDER BY created_at ASC");
    $msgs->execute([$r['id']]);
    if($msgs->rowCount()==0){ echo '<span class="text-white">No conversation.</span>'; }
    else{
        foreach($msgs as $m){
            $cls = $m['sender']=='Manager'?'chat-manager':'chat-employee';
            echo "<div class='$cls'><b>{$m['sender']}:</b> ".htmlspecialchars($m['message'])."</div>";
        }
    }
    ?>
    </div>
</div>
</div>
<?php endforeach; ?>
<?php endif; ?>
</div>

</div>

</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php
/* ===== LAYOUT END ===== */
include 'assets/layout_bottom.php';
?>
