<?php
session_start();
if (!isset($_SESSION['manager_id'])) {
    die('Unauthorized');
}
if (!isset($_SESSION['department']) || $_SESSION['department'] !== 'Sales') {
    header('Location: login.php');
    exit;
}
require 'config/db.php';
$dept = 'Sales';
$dept = strtolower($_SESSION['department']);
$dept = preg_replace('/[^a-z0-9_]/','',$dept);

// Count pending leave requests
$stmt = $pdo->prepare("
    SELECT COUNT(*) as pending_count 
    FROM employee_leave_requests r
    JOIN ".$dept."_employees e ON r.employee_id = e.id
    WHERE r.status='Pending'
");
$stmt->execute();
$pending_count = $stmt->fetchColumn();

$manager_id = $_SESSION['manager_id'];
$manager_table = "manager1_attendance";
$today = date('Y-m-d');

// Check today's attendance
$stmt = $pdo->prepare("SELECT * FROM $manager_table WHERE manager_id=? AND att_date=?");
$stmt->execute([$manager_id, $today]);
$today_att = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- Bootstrap + Icons -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">

<style>
/* ===== Background ===== */
body{
    margin:0;
    font-family: "Segoe UI", Arial, sans-serif;
    background: linear-gradient(135deg,#050814,#0b0f1a);
    color:#fff;
    min-height:100vh;
}
.mesh{
    position:fixed; inset:0;
    background:
        radial-gradient(circle at 15% 20%, rgba(31,140,255,.25), transparent 45%),
        radial-gradient(circle at 80% 25%, rgba(255,138,0,.25), transparent 45%),
        linear-gradient(180deg,#03040a,#070b18);
    animation: hue 30s linear infinite;
    z-index:-5;
}
@keyframes hue{100%{filter:hue-rotate(30deg)}}
.grid{
  position:fixed; inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-1;
}
@keyframes grid{to{transform:translateY(70px)}}

/* ===== Navbar ===== */
.navbar-custom{
    background:linear-gradient(90deg,#0b1220,#111827);
    padding:14px 28px;
}
.navbar-custom span,.navbar-custom .navbar-brand{color:#fff;font-weight:600}
.navbar-brand{
    display:flex;
    align-items:center;
}
.logo{
    margin-right:10px;
    display:flex;align-items:center;gap:8px;font-weight:600;color:#fff;
}
.logo span{color:#1f8cff}
.logo img{height:46px}

/* ===== Glass Container ===== */
.glass{
    max-width:1300px;
    margin:35px auto;
    padding:30px;
    background:rgba(255,255,255,.06);
    backdrop-filter:blur(18px);
    border-radius:20px;
    border:1px solid rgba(255,255,255,.12);
    box-shadow:0 20px 45px rgba(0,0,0,.45);
}

/* ===== Cards ===== */
.card{
    background:rgba(255,255,255,.07);
    border:none;
    border-radius:18px;
    color:#fff;
    transition:.35s;
}
.card:hover{transform:translateY(-6px)}
.shadow-soft{box-shadow:0 10px 30px rgba(0,0,0,.35)}

.stat-card{
    padding:24px;
    text-align:center;
}
.stat-card i{font-size:36px;margin-bottom:12px}
.stat-title{font-size:14px;color:#b0b3c6}
.stat-value{font-size:26px;font-weight:700}

/* ===== Buttons ===== */
.btn-rounded{
    border-radius:30px;
    padding:9px 20px;
    font-weight:600;
}
.btn-glow:hover{
    box-shadow:0 0 20px rgba(255,138,0,.6);
    transform:translateY(-2px);
}

/* Alerts */
.alert{border-radius:14px}
</style>
</head>

<body>
<div class="mesh"></div>
<div class="grid"></div>

<!-- NAVBAR -->
<nav class="navbar navbar-custom d-flex justify-content-between">
    <div class="navbar-brand">
        <div class="logo">
            <img src="images/jg.webp" alt="JG">
            Jillion <span>Gamuts</span>
        </div>
        <i class="fa-solid fa-tachometer-alt me-2"></i>
        <?= htmlspecialchars($dept) ?> Manager Dashboard
    </div>
    <div>
        <span class="me-3"><i class="fa-solid fa-user"></i> <?= htmlspecialchars($_SESSION['department']) ?> Manager</span>
        <a href="logout.php" class="btn btn-danger btn-sm btn-rounded">
            <i class="fa-solid fa-right-from-bracket"></i>
        </a>
    </div>
</nav>

<div class="glass">

<!-- Welcome Card -->
<div class="card shadow-soft mb-4 p-3">
    <h4>Welcome, <?= htmlspecialchars($_SESSION['department']) ?> Manager 👋</h4>
    <p class="text-color mb-0">Department: <?= htmlspecialchars($_SESSION['department']) ?></p>
</div>

<!-- Attendance Alert -->
<?php if(!$today_att): ?>
<div class="alert alert-warning d-flex justify-content-between align-items-center shadow-soft mb-4">
    <div>
        <i class="fa-solid fa-triangle-exclamation me-2"></i>
        Attendance not marked today
    </div>
    <form method="POST" action="mark_attendance.php">
        <button class="btn btn-success btn-rounded btn-sm btn-glow">
            <i class="fa-solid fa-check"></i> Mark Now
        </button>
    </form>
</div>
<?php endif; ?>

<!-- Quick Actions -->
<div class="d-flex flex-wrap gap-3 mb-4">
    <a href="my_attendance.php" class="btn btn-outline-primary btn-rounded btn-glow">
        <i class="fa-solid fa-calendar-check"></i> My Attendance
    </a>
    <a href="manager_request_attendance.php" class="btn btn-warning btn-rounded btn-glow">
        <i class="fa-solid fa-clock"></i> Request Attendance
    </a>
    <a href="my_leaves.php" class="btn btn-outline-info btn-rounded btn-glow">
        <i class="fa-solid fa-file-lines"></i> My Leaves
    </a>
    <a href="manager_apply_leave.php" class="btn btn-outline-info btn-rounded btn-glow">
        <i class="fa-solid fa-plus"></i> Apply Leave
    </a>
    <a href="set_entry_time.php" class="btn btn-outline-info btn-rounded btn-glow">
        <i class="fa-solid fa-plus"></i> Set Entry Time
    </a>
</div>

<!-- Pending Leave Requests -->
<a href="leave_requests.php" class="btn btn-warning btn-rounded mb-4 btn-glow">
    <i class="fa-solid fa-user-check"></i> Pending Leave Requests
    <?php if($pending_count > 0): ?>
        <span class="badge bg-danger ms-1"><?= (int)$pending_count ?></span>
    <?php endif; ?>
</a>

<!-- Stats / Actions Grid -->
<div class="row g-4">

    <div class="col-md-3">
        <div class="stat-card card shadow-soft">
            <i class="fa-solid fa-users text-info"></i>
            <div class="stat-title">Total Team Members</div>
            <div class="stat-value">0</div>
        </div>
    </div>


    <div class="col-md-3">
        <div class="stat-card card shadow-soft">
            <i class="fa-solid fa-check-circle text-success"></i>
            <div class="stat-title">Completed Deals</div>
            <div class="stat-value">0</div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="stat-card card shadow-soft">
            <i class="fa-solid fa-wallet text-success"></i>
            <div class="stat-title">Salary</div>
            <div class="stat-value">$0.00</div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="stat-card card shadow-soft">
            <i class="fa-solid fa-circle-check text-info"></i>
            <a href="final_review.php" class="btn btn-info btn-rounded mt-2 btn-glow">
                <i class="fa-solid fa-eye"></i> Final Files Review
            </a>
        </div>
    </div>

    <div class="col-md-4">
        <div class="stat-card card shadow-soft">
            <i class="fa-solid fa-bullseye text-warning"></i>
            <a href="set_target.php" class="btn btn-warning btn-rounded mt-2 btn-glow">
                <i class="fa-solid fa-plus"></i> Set Target
            </a>
        </div>
    </div>

    <div class="col-md-4">
        <div class="stat-card card shadow-soft">
            <i class="fa-solid fa-user text-info"></i>
            <a href="employee_targets.php" class="btn btn-info btn-rounded mt-2 btn-glow">
                <i class="fa-solid fa-plus"></i> Individual Target
            </a>
        </div>
    </div>

    <div class="col-md-4">
        <div class="stat-card card shadow-soft">
            <i class="fa-solid fa-list-check text-success"></i>
            <a href="kpi_entry1.php" class="btn btn-success btn-rounded mt-2 btn-glow">
                <i class="fa-solid fa-plus"></i>Behavior KPI Entry
            </a>
        </div>
    </div>
     <div class="col-md-4">
        <div class="stat-card card shadow-soft">
            <i class="fa-solid fa-list-check text-success"></i>
            <a href="kpi_entry.php" class="btn btn-success btn-rounded mt-2 btn-glow">
                <i class="fa-solid fa-plus"></i>Quality KPI Entry
            </a>
        </div>
    </div>

    <div class="col-md-4">
        <div class="stat-card card shadow-soft">
            <i class="fa-solid fa-eye text-info"></i>
            <a href="view_kpi.php" class="btn btn-info btn-rounded mt-2 btn-glow">
                <i class="fa-solid fa-eye"></i> View KPI
            </a>
        </div>
    </div>

</div>
</div>

</body>
</html>
