<?php
session_start();
require 'config/db.php';
function blockIfCompleted(PDO $pdo, $project_id){
    $stmt = $pdo->prepare("SELECT status FROM projects WHERE id=?");
    $stmt->execute([$project_id]);
    $status = $stmt->fetchColumn();

    if($status === 'Completed'){
        die('This project is already completed and cannot be modified.');
    }
}

if(!isset($_SESSION['admin_id'])) die('Unauthorized');

/* ===============================
   APPROVE / REJECT PROJECT
================================ */
if(isset($_POST['action'])){
    $pid = $_POST['project_id'];

    // 🚫 BLOCK COMPLETED PROJECT
    blockIfCompleted($pdo, $pid);

    if($_POST['action']=='approve'){

        $pdo->prepare("
            UPDATE projects
            SET status='Approved'
            WHERE id=?
        ")->execute([$pid]);

        $pdo->prepare("
            INSERT INTO project_actions
            (project_id, action_by, action)
            VALUES (?,?,?)
        ")->execute([
            $pid,
            'Admin',
            'Project approved after payment verification'
        ]);

    }elseif($_POST['action']=='reject'){

        $pdo->prepare("
            UPDATE projects
            SET status='Pending'
            WHERE id=?
        ")->execute([$pid]);

        $pdo->prepare("
            INSERT INTO project_actions
            (project_id, action_by, action)
            VALUES (?,?,?)
        ")->execute([
            $pid,
            'Admin',
            'Project rejected (payment issue)'
        ]);
    }
}

/* ===============================
   FETCH PENDING PROJECTS
================================ */
$stmt = $pdo->query("
    SELECT * FROM projects
    WHERE status='Pending'
    ORDER BY created_at DESC
");
$projects = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>JG - Admin Project Approval</title>
<link rel="icon" type="image/png" href="images/jg.webp">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
:root{
  --glass:rgba(255,255,255,.08);
}

*{margin:0;padding:0;box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}
body{background:var(--dark);color:#fff;min-height:100vh;overflow-x:hidden}

/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

/* Grid */
.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}
@keyframes grid{to{transform:translateY(70px)}}

/* ===== Topbar ===== */
.topbar{
  position:fixed;
  top:0;left:0;right:0;
  height:64px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:0 36px;
  background:rgba(8,12,25,.6);
  backdrop-filter:blur(14px);
  border-bottom:1px solid rgba(255,255,255,.06);
  z-index:10;
}
.logo{display:flex;align-items:center;font-weight:600;font-size:1.2rem;}
.status{font-size:13px;display:flex;align-items:center;gap:8px;}
.status::before{
  content:"";
  width:9px;height:9px;
  background:#1cff7a;
  border-radius:50%;
  box-shadow:0 0 12px #1cff7a;
}

/* ===== Glass Panel ===== */
.glass-panel{
  max-width:1000px;
  margin:110px auto 40px;
  padding:28px;
  background:var(--glass);
  backdrop-filter:blur(22px);
  border:1px solid rgba(255,255,255,.14);
  border-radius:18px;
  box-shadow:0 0 50px rgba(31,140,255,.3);
}

/* Card Overrides */
.card{border-radius:0;background:rgba(0,0,0,.35);border:1px solid rgba(255,255,255,.15);color:#fff}
.card-header{background:rgba(8,12,25,.8);border-bottom:1px solid rgba(255,255,255,.1)}
.file-box img{max-width:150px;border:1px solid #ddd;padding:5px}

/* Buttons */
.btn-main, .btn-success, .btn-danger, .btn-outline-secondary{
  transition:.3s;
}
.btn-main:hover, .btn-success:hover, .btn-danger:hover, .btn-outline-secondary:hover{
  transform:translateY(-2px);
}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ===== SAME MASTER HEADER ===== -->
<?php include 'assets/header.php'; ?>

<div class="glass-panel">
<h3 class="mb-4">Pending Projects (Admin Approval)</h3>

<?php if(!$projects): ?>
<div class="alert alert-info">
No pending projects
</div>
<?php endif; ?>

<?php foreach($projects as $p): ?>

<div class="card mb-4">
<div class="card-header">
<b><?= htmlspecialchars($p['title']) ?></b>
<span class="float-end">Status: <?= $p['status'] ?></span>
</div>

<div class="card-body">

<div class="row">
<div class="col-md-6">

<h6>Client Details</h6>
<p>
<b>Name:</b> <?= htmlspecialchars($p['client_name']) ?><br>
<b>Email:</b> <?= htmlspecialchars($p['client_email']) ?><br>
<b>Phone:</b> <?= htmlspecialchars($p['client_phone']) ?>
</p>

<h6>Project Details</h6>
<p>
<b>Description:</b><br>
<?= nl2br(htmlspecialchars($p['description'])) ?><br><br>
<b>Price:</b> <?= $p['price'] ?>
</p>

<h6>Sales Info</h6>
<p><?= htmlspecialchars($p['sales_name']) ?></p>

</div>

<div class="col-md-6">

<h6>Client Files</h6>
<div class="d-flex flex-wrap gap-2 mb-3">
<?php
$files = $pdo->prepare("
    SELECT * FROM project_files
    WHERE project_id=? AND file_stage='Client'
");
$files->execute([$p['id']]);
foreach($files as $f):
?>
<a target="_blank" href="../employees/uploads/projects/<?= $f['file_path'] ?>" class="btn btn-outline-secondary btn-sm">
View File
</a>
<?php endforeach; ?>
</div>

<h6>Payment Screenshot</h6>
<div class="file-box">
<?php
$pay = $pdo->prepare("
    SELECT file_path FROM project_files
    WHERE project_id=? AND file_stage='Payment'
    LIMIT 1
");
$pay->execute([$p['id']]);
$payFile = $pay->fetchColumn();
if($payFile):
?>
<a target="_blank" href="../employees/uploads/payments/<?= $payFile ?>">
<img src="../employees/uploads/payments/<?= $payFile ?>">
</a>
<?php else: ?>
<p class="text-danger">No payment file</p>
<?php endif; ?>
</div>

</div>
</div>

<hr>

<?php if($p['status'] === 'Completed'): ?>
    <div class="alert alert-success text-center">
        This project is completed and locked.
    </div>
<?php else: ?>
    <form method="POST" class="d-flex gap-2">
        <input type="hidden" name="project_id" value="<?= $p['id'] ?>">

        <button name="action" value="approve" class="btn btn-success w-50">
            Approve
        </button>
        <button name="action" value="reject" class="btn btn-danger w-50">
            Reject
        </button>
    </form>
<?php endif; ?>

<?php endforeach; ?>
</div>

<script src="assets/particles.js"></script>
</body>
</html>
