<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">


<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>

/* ================= ROOT THEME ================= */
:root{
  --blue:#0097fc;
  --orange:#ff6a00;
  --dark:#050814;
  --glass:rgba(255,255,255,.08);
  --glowBlue:rgba(0,151,252,.6);
}

/* ================= RESET ================= */
*{
  margin:0;
  padding:0;
  box-sizing:border-box;
  font-family:Inter,Segoe UI,Arial,sans-serif;
}

html,body{
  width:100%;
  height:100%;
  background:var(--dark);
  overflow:hidden;
  color:#fff;
}

/* ================= BACKGROUND LAYERS ================= */

/* Gradient Mesh */
.mesh{
  position:fixed;
  inset:0;
  background:
    radial-gradient(circle at 20% 20%, rgba(0,151,252,.35), transparent 45%),
    radial-gradient(circle at 80% 30%, rgba(255,106,0,.3), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:0;
}
@keyframes mesh{
  from{filter:hue-rotate(0deg)}
  to{filter:hue-rotate(25deg)}
}

/* Tech Grid */
.grid{
  position:fixed;
  inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:1;
}
@keyframes grid{
  from{transform:translateY(0)}
  to{transform:translateY(70px)}
}

/* Particle Canvas */
#particles{
  position:fixed;
  inset:0;
  z-index:2;
}

/* ================= TOP BAR ================= */
.topbar{
  position:fixed;
  top:0;left:0;right:0;
  height:64px;
  padding:0 36px;
  display:flex;
  justify-content:space-between;
  align-items:center;
  background:rgba(8,12,25,.6);
  backdrop-filter:blur(14px);
  border-bottom:1px solid rgba(255,255,255,.08);
  z-index:10;
}
.logo{
  display:flex;
  align-items:center;
  gap:10px;
  font-weight:600;
}
.logo img{height:50px}
.logo span{color:var(--blue)}

.status{
  font-size:13px;
  display:flex;
  align-items:center;
  gap:8px;
}
.status::before{
  content:"";
  width:9px;height:9px;
  background:#1cff7a;
  border-radius:50%;
  box-shadow:0 0 12px #1cff7a;
}

/* ================= LOGIN ================= */
.wrapper{
  position:relative;
  z-index:5;
  height:100vh;
  display:flex;
  align-items:center;
  justify-content:center;
}

.login{
  width:390px;
  padding:36px;
  background:var(--glass);
  backdrop-filter:blur(22px);
  border:1px solid rgba(255,255,255,.14);
  border-radius:18px;
  box-shadow:0 0 50px var(--glowBlue);
  animation:enter .9s ease;
}
@keyframes enter{
  from{opacity:0;transform:translateY(40px)}
  to{opacity:1}
}

.login h2{margin-bottom:6px}
.login p{font-size:13px;opacity:.6;margin-bottom:24px}

.field{margin-bottom:18px}
.field input{
  width:100%;
  padding:14px;
  background:rgba(0,0,0,.35);
  border:1px solid rgba(255,255,255,.15);
  border-radius:10px;
  color:#fff;
}
.field input:focus{
  outline:none;
  border-color:var(--blue);
  box-shadow:0 0 0 1px var(--blue),0 0 20px var(--glowBlue);
}

button{
  width:100%;
  padding:14px;
  border:none;
  border-radius:10px;
  background:linear-gradient(135deg,var(--blue),var(--orange));
  font-weight:600;
  cursor:pointer;
}
button:hover{
  box-shadow:0 0 30px var(--glowBlue);
  transform:translateY(-2px);
}

/* ================= FOOTER ================= */
footer{
  position:fixed;
  bottom:16px;
  width:100%;
  text-align:center;
  font-size:12px;
  opacity:.4;
  z-index:5;
}

</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<div class="topbar">
  <div class="logo">
    <img src="images/jg.webp" alt="JG">
    Jillion <span>Gamuts</span>
  </div>
  <div class="status">System Online</div>
</div>

<div class="wrapper">
  <div class="login">
    <h2>Admin Login</h2>
    <p>Enterprise management authorization</p>

    <?php if(isset($_GET['error'])): ?>
      <div class="alert alert-danger">Invalid Email or Password</div>
    <?php endif; ?>

    <form method="post" action="login_action.php">
      <div class="field">
        <input type="email" name="email" placeholder="Email" required>
      </div>
      <div class="field">
        <input type="password" name="password" placeholder="Password" required>
      </div>
      <button>Login</button>
    </form>
  </div>
</div>

<footer>© Jillion Gamuts</footer>

<script>
const canvas = document.getElementById("particles");
const ctx = canvas.getContext("2d");

let w = canvas.width = window.innerWidth;
let h = canvas.height = window.innerHeight;

window.addEventListener("resize",()=>{
  w = canvas.width = window.innerWidth;
  h = canvas.height = window.innerHeight;
});

class Particle{
  constructor(){
    this.x=Math.random()*w;
    this.y=Math.random()*h;
    this.size=Math.random()*3+1;
    this.vx=(Math.random()-0.5)*1.2;
    this.vy=(Math.random()-0.5)*1.2;
    this.color=Math.random()>.5?"#0097fc":"#ff6a00";
  }
  draw(){
    ctx.beginPath();
    ctx.arc(this.x,this.y,this.size,0,Math.PI*2);
    ctx.fillStyle=this.color;
    ctx.fill();
  }
  update(){
    this.x+=this.vx;
    this.y+=this.vy;
    if(this.x<0||this.x>w) this.vx*=-1;
    if(this.y<0||this.y>h) this.vy*=-1;
  }
}

const particles=[];
for(let i=0;i<120;i++) particles.push(new Particle());

function connect(){
  for(let a=0;a<particles.length;a++){
    for(let b=a;b<particles.length;b++){
      const dx=particles[a].x-particles[b].x;
      const dy=particles[a].y-particles[b].y;
      const d=Math.sqrt(dx*dx+dy*dy);
      if(d<120){
        ctx.strokeStyle="rgba(0,151,252,.2)";
        ctx.lineWidth=1;
        ctx.beginPath();
        ctx.moveTo(particles[a].x,particles[a].y);
        ctx.lineTo(particles[b].x,particles[b].y);
        ctx.stroke();
      }
    }
  }
}

(function animate(){
  ctx.clearRect(0,0,w,h);
  particles.forEach(p=>{p.update();p.draw();});
  connect();
  requestAnimationFrame(animate);
})();
</script>

</body>
</html>
