<?php
require '../config/auth.php';
require '../config/db.php';

/* ===== BACKEND (UNCHANGED) ===== */

$total_managers = $pdo->query("SELECT COUNT(*) FROM managers")->fetchColumn();

$total_employees = 0;
$employee_tables = ['sales_employees','design_employees','development_employees','marketing_employees'];
foreach($employee_tables as $table){
    $total_employees += $pdo->query("SELECT COUNT(*) FROM $table")->fetchColumn();
}

$total_pending_leaves = $pdo->query("SELECT COUNT(*) FROM employee_leave_requests WHERE status='ManagerApproved'")->fetchColumn();
$total_pending_leaves_design = $pdo->query("SELECT COUNT(*) FROM design_employee_leave_requests WHERE status='ManagerApproved'")->fetchColumn();
$total_pending_leaves_development = $pdo->query("SELECT COUNT(*) FROM development_employee_leave_requests WHERE status='ManagerApproved'")->fetchColumn();

$departments = ['sales','design','development','marketing'];
$total_pending = 0;
foreach($departments as $d){
    $total_pending += $pdo->query("SELECT COUNT(*) FROM {$d}_manager_leaves WHERE status='Pending'")->fetchColumn();
}

$pending_att_req  = $pdo->query("SELECT COUNT(*) FROM attendance_requests WHERE status='Pending'")->fetchColumn();
$pending_att_req2 = $pdo->query("SELECT COUNT(*) FROM design_attendance_requests WHERE status='Pending'")->fetchColumn();
$pending_att_req3 = $pdo->query("SELECT COUNT(*) FROM development_attendance_requests WHERE status='Pending'")->fetchColumn();
$requests = $pdo->query("SELECT COUNT(*) FROM manager_attendance_requests WHERE status='Pending'")->fetchColumn();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap" rel="stylesheet">

<style>

/* ================= THEME ================= */
:root{
  --blue:#0097fc;
  --orange:#ff6a00;
  --dark:#050814;
  --glass:rgba(255,255,255,.08);
  --border:rgba(255,255,255,.15);
  --glow:rgba(0,151,252,.45);
  --text:#e5e7eb;
}

/* ================= RESET ================= */
*{margin:0;padding:0;box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}
html,body{
  width:100%;height:100%;
  background:var(--dark);
  color:var(--text);
  overflow-x:hidden;
}

/* ================= BACKGROUND ================= */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 20% 20%, rgba(0,151,252,.35), transparent 45%),
    radial-gradient(circle at 80% 30%, rgba(255,106,0,.3), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:0;
}
@keyframes mesh{to{filter:hue-rotate(25deg)}}

.grid-bg{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.05) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.05) 1px, transparent 1px);
  background-size:60px 60px;
  z-index:1;
}

#particles{
  position:fixed;inset:0;
  z-index:2;
}

/* ================= SIDEBAR ================= */
.sidebar{
  position:fixed;top:0;left:0;
  width:260px;height:100vh;
  background:var(--glass);
  backdrop-filter:blur(18px);
  border-right:1px solid var(--border);
  padding:22px 16px;
  z-index:10;
}
.logo{
  display:flex;align-items:center;gap:10px;
  font-weight:800;margin-bottom:32px
}
.logo img{height:56px}
.logo span{color:var(--blue)}

.menu a{
  display:flex;gap:12px;
  padding:12px 14px;
  border-radius:12px;
  color:#cbd5f5;
  text-decoration:none;
  margin-bottom:6px;
  transition:.35s;
}
.menu a:hover,.menu a.active{
  background:linear-gradient(135deg,var(--orange),var(--blue));
  color:#fff;
  transform:translateX(6px);
}

/* ================= MAIN ================= */
.main{
  margin-left:260px;
  padding:28px;
  position:relative;
  z-index:5;
}

.glass{
  background:var(--glass);
  border:1px solid var(--border);
  backdrop-filter:blur(18px);
  border-radius:18px;
}
.glass-panel{
  background:var(--glass);
  border:1px solid var(--border);
  backdrop-filter:blur(18px);
  border-radius:18px;
}
.glass-dept{
  background:var(--glass);
  border:1px solid var(--border);
  backdrop-filter:blur(18px);
  border-radius:18px;
  padding:20px;
}

/* ================= TOPBAR ================= */
.topbar{
  display:flex;justify-content:space-between;align-items:center;
  padding:18px 22px;margin-bottom:26px
}
.status{
  font-size:13px;
  display:flex;align-items:center;gap:8px
}
.status::before{
  content:"";width:9px;height:9px;
  background:#1cff7a;border-radius:50%;
  box-shadow:0 0 12px #1cff7a;
}

/* ================= KPI ================= */
.grid{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
  gap:22px;margin-bottom:32px
}
.kpi{text-align:center;padding:26px}
.kpi i{font-size:30px;color:var(--blue)}
.stat{font-size:36px;font-weight:800}

/* ================= CARDS ================= */
.card-glass{
  padding:22px;text-align:center;
  transition:.45s
}
.card-glass:hover{
  transform:translateY(-8px);
  box-shadow:0 0 40px var(--glow);
}

.section-title{
  font-weight:700;
  margin-bottom:16px;
  display:flex;gap:10px;align-items:center
}

</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid-bg"></div>
<canvas id="particles"></canvas>

<!-- SIDEBAR -->
<aside class="sidebar">
  <div class="logo">
    <img src="images/jg.webp">
    Jillion <span>Gamuts</span>
  </div>
  <nav class="menu">
    <a class="active"><i class="fa fa-grid"></i> Dashboard</a>
    <a href="managers.php"><i class="fa fa-user-tie"></i> Managers</a>
    <a href="employees.php"><i class="fa fa-users"></i> Employees</a>
    <a href="#attendance"><i class="fa fa-calendar-check"></i> Attendance</a>
    <a href="#leave"><i class="fa fa-plane"></i> Leaves</a>
    <a href="#controls"><i class="fa fa-sliders"></i> Controls</a>
    <a href="../logout.php"><i class="fa fa-lock"></i> Logout</a>
  </nav>
</aside>

<!-- MAIN -->
<main class="main">

<header class="topbar glass">
  <h4>Welcome, <?= htmlspecialchars($_SESSION['hr_name']) ?></h4>
  <div class="status">System Online</div>
</header>

<section class="grid">
  <div class="glass kpi">
    <i class="fa fa-user-tie"></i>
    <div class="stat"><?= $total_managers ?></div>
    <small>Total Managers</small>
  </div>
  <div class="glass kpi">
    <i class="fa fa-users"></i>
    <div class="stat"><?= $total_employees ?></div>
    <small>Total Employees</small>
  </div>
</section>
<div id="attendance" class="panel glass-panel p-4 mb-4 fade-up"> <div class="section-title mb-3"> <i class="fa-solid fa-user-tie icon-gradient"></i> Managers Attendance </div> <div class="row g-3"> <div class="col-md-4"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-user-tie icon-gradient"></i> <h6 class="mt-2">Managers</h6> <a href="manager_attendance.php" class="btn btn-danger btn-sm mt-2 glass-btn"> Review Attendance </a> </div> </div> </div> <hr class="glass-divider my-4"> <div class="section-title mb-3"> <i class="fa-solid fa-calendar-check icon-gradient2"></i> Department Attendance </div> <div class="row g-3"> <!-- SALES --> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-chart-line icon-gradient2"></i> <h6 class="mt-2">Sales</h6> <a href="sales_attendance.php" class="btn btn-primary btn-sm mt-2 glass-btn"> View Attendance </a> </div> </div> <!-- DESIGN --> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-pen-ruler icon-gradient2"></i> <h6 class="mt-2">Design</h6> <a href="design_attendance.php" class="btn btn-primary btn-sm mt-2 glass-btn"> View Attendance </a> </div> </div> <!-- DEVELOPMENT --> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-code icon-gradient2"></i> <h6 class="mt-2">Development</h6> <a href="development_attendance.php" class="btn btn-primary btn-sm mt-2 glass-btn"> View Attendance </a> </div> </div> <!-- MARKETING --> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-bullhorn icon-gradient2"></i> <h6 class="mt-2">Marketing</h6> <a href="marketing_attendance.php" class="btn btn-primary btn-sm mt-2 glass-btn"> View Attendance </a> </div> </div> </div> </div> <!-- DEPARTMENT LEAVES --> <div id="leave" class="panel glass-panel p-4 mb-4 fade-up"> <div class="section-title mb-3"> <i class="fa-solid fa-user-tie icon-gradient"></i> Managers Leave Approvals </div> <div class="row g-3"> <!-- MANAGERS --> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-user-tie icon-gradient"></i> <h6 class="mt-2">Managers</h6> <p class=" small">Pending approvals</p> <span class="badge bg-danger"><?= $total_pending ?></span><br> <a href="hr_manager_leaves.php" class="btn btn-danger btn-sm mt-2"> Review </a> </div> </div> </div> <hr> <div class="section-title"> <i class="fa-solid fa-calendar-check icon-gradient2"></i> Department Leave Approvals </div> <div class="row g-3"> <!-- SALES --> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-chart-line icon-gradient2"></i> <h6 class="mt-2">Sales</h6> <p class=" small">Manager approved</p> <span class="badge bg-danger"><?= $total_pending_leaves ?></span><br> <a href="leave_approvals.php" class="btn btn-primary btn-sm mt-2"> Review </a> </div> </div> <!-- DESIGN --> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-pen-ruler icon-gradient2"></i> <h6 class="mt-2">Design</h6> <p class=" small">Manager approved</p> <span class="badge bg-danger"><?= $total_pending_leaves_design ?></span><br> <a href="design_leave_approvals.php" class="btn btn-primary btn-sm mt-2"> Review </a> </div> </div> <!-- DEVELOPMENT --> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-code icon-gradient2"></i> <h6 class="mt-2">Development</h6> <p class=" small">Manager approved</p> <span class="badge bg-danger"><?= $total_pending_leaves_development ?></span><br> <a href="development_leave_approvals.php" class="btn btn-primary btn-sm mt-2"> Review </a> </div> </div> <!-- MARKETING --> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-bullhorn icon-gradient2"></i> <h6 class="mt-2">Marketing</h6> <p class=" small">Manager approved</p> <span class="badge bg-danger"><?= $total_pending_leaves_development ?></span><br> <a href="development_leave_approvals.php" class="btn btn-primary btn-sm mt-2"> Review </a> </div> </div> </div> </div> <!-- ATTENDANCE REQUESTS --> <div id="attendancereq" class="panel glass-panel p-4 mb-4"> <div class="section-title"> <i class="fa-solid fa-user-tie icon-gradient"></i> Attendance Requests </div> <div class="row g-3"> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-user-tie icon-gradient"></i> <h6 class="mt-2">Managers</h6> <span class="badge bg-danger"><?= $requests ?></span><br> <a href="manager_attendance_requests.php" class="btn btn-danger btn-sm mt-2">Review</a> </div> </div> <hr> <div class="section-title"> <i class="fa-solid fa-calendar-check icon-gradient2"></i> Attendance Requests </div> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-chart-line icon-gradient2"></i> <h6 class="mt-2">Sales</h6> <span class="badge bg-danger"><?= $pending_att_req ?></span><br> <a href="attendance_requests.php" class="btn btn-primary btn-sm mt-2">Review</a> </div> </div> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-pen-ruler icon-gradient2"></i> <h6 class="mt-2">Design</h6> <span class="badge bg-danger"><?= $pending_att_req2 ?></span><br> <a href="design_attendance_requests.php" class="btn btn-primary btn-sm mt-2">Review</a> </div> </div> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-code icon-gradient2"></i> <h6 class="mt-2">Development</h6> <span class="badge bg-danger"><?= $pending_att_req3 ?></span><br> <a href="development_attendance_requests.php" class="btn btn-primary btn-sm mt-2">Review</a> </div> </div> <!-- MARKETING --> <div class="col-md-3"> <div class="dept-card glass-dept text-center"> <i class="fa-solid fa-bullhorn icon-gradient2"></i> <h6 class="mt-2">Marketing</h6> <span class="badge bg-danger"><?= $pending_att_req3 ?></span><br> <a href="development_attendance_requests.php" class="btn btn-primary btn-sm mt-2">Review</a> </div> </div> </div> </div> <!-- HR CONTROLS --> <div id="controls" class="panel glass-panel p-4"> <div class="section-title"> <i class="fa-solid fa-sliders text-warning"></i> HR Controls </div> <br> <div class="row g-3"> <div class="col-md-4"> <div class="dept-card glass-dept"> <h6>Employee Entry Time</h6> <p class=" small">Shift & timings</p> <a href="set_emp_entry_time.php" class="btn btn-primary btn-sm">Configure</a> </div> </div> <div class="col-md-4"> <div class="dept-card glass-dept"> <h6>Holidays</h6> <p class=" small">Company calendar</p> <a href="mark_holidays.php" class="btn btn-primary btn-sm">Manage</a> </div> </div> </div> </div> </div>
<!-- You can keep ALL your existing panels below —
     sirf class="glass card-glass" use karo -->

</main>

<script>
const canvas = document.getElementById("particles");
const ctx = canvas.getContext("2d");

let w = canvas.width = window.innerWidth;
let h = canvas.height = window.innerHeight;

window.addEventListener("resize",()=>{
  w = canvas.width = window.innerWidth;
  h = canvas.height = window.innerHeight;
});

class Particle{
  constructor(){
    this.x=Math.random()*w;
    this.y=Math.random()*h;
    this.size=Math.random()*3+1;
    this.vx=(Math.random()-0.5)*1.2;
    this.vy=(Math.random()-0.5)*1.2;
    this.color=Math.random()>.5?"#0097fc":"#ff6a00";
  }
  draw(){
    ctx.beginPath();
    ctx.arc(this.x,this.y,this.size,0,Math.PI*2);
    ctx.fillStyle=this.color;
    ctx.fill();
  }
  update(){
    this.x+=this.vx;
    this.y+=this.vy;
    if(this.x<0||this.x>w) this.vx*=-1;
    if(this.y<0||this.y>h) this.vy*=-1;
  }
}

const particles=[];
for(let i=0;i<120;i++) particles.push(new Particle());

function connect(){
  for(let a=0;a<particles.length;a++){
    for(let b=a;b<particles.length;b++){
      const dx=particles[a].x-particles[b].x;
      const dy=particles[a].y-particles[b].y;
      const d=Math.sqrt(dx*dx+dy*dy);
      if(d<120){
        ctx.strokeStyle="rgba(0,151,252,.2)";
        ctx.lineWidth=1;
        ctx.beginPath();
        ctx.moveTo(particles[a].x,particles[a].y);
        ctx.lineTo(particles[b].x,particles[b].y);
        ctx.stroke();
      }
    }
  }
}

(function animate(){
  ctx.clearRect(0,0,w,h);
  particles.forEach(p=>{p.update();p.draw();});
  connect();
  requestAnimationFrame(animate);
})();
</script>

</body>
</html>
