<?php
require '../config/auth.php';
require '../config/db.php';

if (!isset($_GET['id'], $_GET['table'])) die('Missing parameters');

$id = intval($_GET['id']);
$table = $_GET['table'];

// Validate table
$valid_tables = ['sales_employees','design_employees','development_employees','marketing_employees'];
if(!in_array($table, $valid_tables)) die('Invalid table');

$error = '';
$success = '';

// Fetch employee data
$stmt = $pdo->prepare("SELECT * FROM $table WHERE id=?");
$stmt->execute([$id]);
$emp = $stmt->fetch(PDO::FETCH_ASSOC);
if(!$emp) die('Employee not found');

if($_POST){
    $full_name = $_POST['full_name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $cnic = $_POST['cnic'];
    $gender = $_POST['gender'];
    $dob = $_POST['dob'];
    $address = $_POST['address'];
    $designation = $_POST['designation'];
    $employment_type = $_POST['employment_type'];
    $joining_date = $_POST['joining_date'];
    $basic_salary = $_POST['basic_salary'];

    if(!$full_name || !$email) {
        $error = "Full Name and Email are required";
    } else {
        $stmt = $pdo->prepare("
            UPDATE $table SET 
            full_name=?, email=?, phone=?, cnic=?, gender=?, dob=?, address=?, designation=?, employment_type=?, joining_date=?, basic_salary=?
            WHERE id=?
        ");
        $stmt->execute([
            $full_name, $email, $phone, $cnic, $gender, $dob, $address, $designation, $employment_type, $joining_date, $basic_salary, $id
        ]);
        $success = "Employee updated successfully";

        // Refresh employee data
        $stmt = $pdo->prepare("SELECT * FROM $table WHERE id=?");
        $stmt->execute([$id]);
        $emp = $stmt->fetch(PDO::FETCH_ASSOC);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="../assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
:root{

  --glass:rgba(255,255,255,.08);
}

*{margin:0;padding:0;box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}
body{background:var(--dark);color:#fff;min-height:100vh;overflow-x:hidden}

/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

/* Grid */
.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}
@keyframes grid{to{transform:translateY(70px)}}

/* ===== Glass Form Panel ===== */
.glass-panel{
  max-width:700px;
  margin:110px auto 40px;
  padding:28px;
  background:var(--glass);
  backdrop-filter:blur(22px);
  border:1px solid rgba(255,255,255,.14);
  border-radius:18px;
  box-shadow:0 0 50px rgba(31,140,255,.3);
}

/* Inputs */
.form-control,.form-select,textarea{
  background:rgba(0,0,0,.35);
  border:1px solid rgba(255,255,255,.15);
  color:#fff;
}
.form-control:focus,.form-select:focus,textarea:focus{
  border-color:var(--blue);
  box-shadow:0 0 0 1px var(--blue),0 0 18px rgba(0,151,252,.45);
  background:rgba(0,0,0,.4);
  color:#fff;
}
label{font-size:13px;opacity:.8}

/* Buttons */
.btn-main{
  background:linear-gradient(135deg,var(--blue),var(--orange));
  border:none;
  color:#fff;
  padding:12px;
  font-weight:600;
  width:100%;
  box-shadow:0 0 25px rgba(0,151,252,.4);
  transition:.3s;
}
.btn-main:hover{
  transform:translateY(-2px);
  box-shadow:0 0 35px rgba(255,138,0,.6);
}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<?php include '../assets/header.php'; ?>


<div class="glass-panel">
<h4 class="mb-4">Edit Employee</h4>
<a href="employees.php" class="btn btn-secondary mb-3">Back</a>

<?php if($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>
<?php if($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>

<form method="POST">
<div class="row">
<div class="col-md-6 mb-3">
<label>Full Name</label>
<input type="text" name="full_name" class="form-control" value="<?= htmlspecialchars($emp['full_name']) ?>" required>
</div>
<div class="col-md-6 mb-3">
<label>Email</label>
<input type="email" name="email" class="form-control" value="<?= htmlspecialchars($emp['email']) ?>" required>
</div>
</div>

<div class="row">
<div class="col-md-6 mb-3">
<label>Phone</label>
<input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($emp['phone']) ?>">
</div>
<div class="col-md-6 mb-3">
<label>CNIC</label>
<input type="text" name="cnic" class="form-control" value="<?= htmlspecialchars($emp['cnic']) ?>">
</div>
</div>

<div class="row">
<div class="col-md-4 mb-3">
<label>Gender</label>
<select name="gender" class="form-select">
<option value="">Select</option>
<option value="Male" <?= $emp['gender']=='Male'?'selected':'' ?>>Male</option>
<option value="Female" <?= $emp['gender']=='Female'?'selected':'' ?>>Female</option>
<option value="Other" <?= $emp['gender']=='Other'?'selected':'' ?>>Other</option>
</select>
</div>
<div class="col-md-4 mb-3">
<label>DOB</label>
<input type="date" name="dob" class="form-control" value="<?= $emp['dob'] ?>">
</div>
<div class="col-md-4 mb-3">
<label>Designation</label>
<input type="text" name="designation" class="form-control" value="<?= htmlspecialchars($emp['designation']) ?>">
</div>
</div>

<div class="mb-3">
<label>Address</label>
<textarea name="address" class="form-control"><?= htmlspecialchars($emp['address']) ?></textarea>
</div>

<div class="row">
<div class="col-md-4 mb-3">
<label>Employment Type</label>
<select name="employment_type" class="form-select">
<option value="Permanent" <?= $emp['employment_type']=='Permanent'?'selected':'' ?>>Permanent</option>
<option value="Contract" <?= $emp['employment_type']=='Contract'?'selected':'' ?>>Contract</option>
<option value="Intern" <?= $emp['employment_type']=='Intern'?'selected':'' ?>>Intern</option>
</select>
</div>
<div class="col-md-4 mb-3">
<label>Joining Date</label>
<input type="date" name="joining_date" class="form-control" value="<?= $emp['joining_date'] ?>">
</div>
<div class="col-md-4 mb-3">
<label>Basic Salary</label>
<input type="number" step="0.01" name="basic_salary" class="form-control" value="<?= $emp['basic_salary'] ?>">
</div>
</div>

<button class="btn-main">Update Employee</button>
</form>
</div>
<script src="../assets/particles.js"></script>
</body>
</html>
