<?php
ini_set('display_errors',1);
error_reporting(E_ALL);

$BASE = '/home/jgsuite/public_html';

function cleanPath($base,$path){
    $full = realpath($base.'/'.$path);
    if(!$full) return false;
    if(strpos($full, realpath($base)) !== 0) return false;
    return $full;
}

$path = $_GET['p'] ?? '';
$cur = cleanPath($BASE,$path);

if(!$cur) $cur = realpath($BASE);

$relPath = trim(str_replace(realpath($BASE),'',$cur),'/');

$msg='';

/* ================= upload ================= */

if(isset($_POST['upload'])){
    if(!empty($_FILES['file']['name'])){
        $name = basename($_FILES['file']['name']);
        $dest = $cur.'/'.$name;

        if(move_uploaded_file($_FILES['file']['tmp_name'],$dest)){
            $msg="Uploaded / replaced successfully.";
        }else{
            $msg="Upload failed.";
        }
    }
}

/* ================= delete ================= */

if(isset($_GET['del'])){
    $del = cleanPath($BASE,$_GET['del']);
    if($del && is_file($del)){
        unlink($del);
        $msg="File deleted.";
    }
}

/* ================= breadcrumb ================= */

function breadcrumb($path){
    if($path=='') return '';

    $parts = explode('/',$path);
    $build='';
    $out='';

    foreach($parts as $p){
        $build .= ($build==''?'':"/").$p;
        $out .= ' / <a href="?p='.urlencode($build).'">'.$p.'</a>';
    }

    return $out;
}

$items = scandir($cur);
?>
<!DOCTYPE html>
<html>
<head>
<title>HR File Manager</title>

<style>
body{
background:#0d0f12;
font-family:system-ui,Segoe UI,Arial;
color:#fff;
margin:0;
padding:0;
}

.wrapper{
max-width:1100px;
margin:auto;
padding:30px;
}

.topbar{
background:#141820;
padding:15px 20px;
border-radius:10px;
margin-bottom:20px;
}

a{color:#6dd6ff;text-decoration:none}
a:hover{text-decoration:underline}

.box{
background:#141820;
border-radius:12px;
padding:20px;
}

table{
width:100%;
border-collapse:collapse;
}

th,td{
padding:12px;
border-bottom:1px solid #222;
}

tr:hover{
background:#1b2030;
}

.folder{font-weight:600}
.file{color:#ccc}

.btn{
background:#2b7cff;
border:0;
color:white;
padding:8px 14px;
border-radius:8px;
cursor:pointer;
}

.btn-del{
color:#ff6b6b;
}

.path{
color:#aaa;
font-size:14px;
margin-bottom:8px;
}

.uploadBox{
margin-top:20px;
padding:15px;
background:#0f1219;
border-radius:10px;
}

input[type=file]{
color:white;
}

.msg{
color:#7CFF7C;
margin:10px 0;
}
</style>
</head>
<body>

<div class="wrapper">

<div class="topbar">
<b>HR Website File Manager</b>
<div class="path">
/ <a href="?">home</a><?= breadcrumb($relPath) ?>
</div>
</div>

<?php if($msg): ?>
<div class="msg"><?= htmlspecialchars($msg) ?></div>
<?php endif; ?>

<div class="box">

<table>
<tr>
<th>Name</th>
<th width="120">Type</th>
<th width="120">Action</th>
</tr>

<?php
// back link
if($cur != realpath($BASE)){
    $parent = dirname($relPath);
    echo "<tr>
        <td colspan='3'>
        <a href='?p=".urlencode($parent)."'>⬅ Back</a>
        </td>
    </tr>";
}

foreach($items as $i){

    if($i=='.'||$i=='..') continue;

    $full = $cur.'/'.$i;
    $rel  = ltrim(($relPath==''?$i:$relPath.'/'.$i),'/');

    if(is_dir($full)){

        echo "<tr>
            <td class='folder'>📁 <a href='?p=".urlencode($rel)."'>$i</a></td>
            <td>Folder</td>
            <td></td>
        </tr>";

    }else{

        echo "<tr>
            <td class='file'>📄 $i</td>
            <td>File</td>
            <td>
            <a class='btn-del' onclick=\"return confirm('Delete file?')\" href='?p=".urlencode($relPath)."&del=".urlencode($rel)."'>Delete</a>
            </td>
        </tr>";
    }
}
?>

</table>

<div class="uploadBox">

<b>Upload / Replace file in this folder</b>
<br><br>

<form method="post" enctype="multipart/form-data">
<input type="file" name="file" required>
<button class="btn" name="upload">Upload here</button>
</form>

<small style="color:#888">
Current folder:
<?= $relPath=='' ? '/' : '/'.$relPath ?>
</small>

</div>

</div>

</div>
</body>
</html>
