<?php
require 'config/db.php';

/* ================= DEFAULT MONTH & YEAR ================= */
$month = $_POST['month'] ?? date('n');
$year  = $_POST['year']  ?? date('Y');

/* ================= DESIGNERS ================= */
$designers = $pdo->query("
    SELECT id, full_name 
    FROM design_employees 
    ORDER BY full_name
")->fetchAll(PDO::FETCH_ASSOC);

/* ================= SAVE KPI ================= */
$msg = '';
if(isset($_POST['save_kpi'])){

    $designer_id   = $_POST['designer_id'];
    $designer_name = $_POST['designer_name'];

    /* ===== Attendance (6) ===== */
    $stmt = $pdo->prepare("
        SELECT COUNT(*) 
        FROM design_employee_attendance
        WHERE employee_id=? 
        AND MONTH(att_date)=? 
        AND YEAR(att_date)=?
        AND status='Present'
    ");
    $stmt->execute([$designer_id,$month,$year]);
    $presentDays = (int)$stmt->fetchColumn();

    $daysInMonth = cal_days_in_month(CAL_GREGORIAN,$month,$year);
    $attendancePercent = ($daysInMonth>0) ? ($presentDays/$daysInMonth)*100 : 0;

    if($attendancePercent >= 86) $attendance = 6;
    elseif($attendancePercent >= 76) $attendance = 5;
    elseif($attendancePercent >= 66) $attendance = 4;
    elseif($attendancePercent >= 51) $attendance = 3;
    elseif($attendancePercent >= 31) $attendance = 2;
    elseif($attendancePercent >= 1)  $attendance = 1;
    else $attendance = 0;

    /* ===== Punctuality (4) ===== */
    $lateStmt = $pdo->prepare("
        SELECT COUNT(*) 
        FROM design_employee_late_log
        WHERE employee_id=? 
        AND MONTH(log_date)=? 
        AND YEAR(log_date)=?
    ");
    $lateStmt->execute([$designer_id,$month,$year]);
    $late = (int)$lateStmt->fetchColumn();

    if($late == 0) $punctuality = 4;
    elseif($late == 1) $punctuality = 3;
    elseif($late == 2) $punctuality = 2;
    elseif($late == 3) $punctuality = 1;
    else $punctuality = 0;

    /* ===== Manual Behavior (15) ===== */
    $communication     = min(max($_POST['communication'],0),3);
    $team_coordination = min(max($_POST['team_coordination'],0),3);
    $overtime          = min(max($_POST['overtime'],0),4);
    $crm_discipline    = min(max($_POST['crm_discipline'],0),3);
    $professionalism   = min(max($_POST['professionalism'],0),2);

    /* ===== TOTAL BEHAVIOR ===== */
    $total = $punctuality + $attendance + $communication + $team_coordination + $overtime + $crm_discipline + $professionalism;

    /* ===== UPSERT INTO DB ===== */
    $save = $pdo->prepare("
        INSERT INTO design_behavior_kpi
        (designer_id, designer_name, month, year,
         punctuality, attendance,
         communication, team_coordination, overtime,
         crm_discipline, professionalism, total_behavior)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?)
        ON DUPLICATE KEY UPDATE
            punctuality=VALUES(punctuality),
            attendance=VALUES(attendance),
            communication=VALUES(communication),
            team_coordination=VALUES(team_coordination),
            overtime=VALUES(overtime),
            crm_discipline=VALUES(crm_discipline),
            professionalism=VALUES(professionalism),
            total_behavior=VALUES(total_behavior),
            updated_at=CURRENT_TIMESTAMP
    ");
    $save->execute([
        $designer_id, $designer_name, $month, $year,
        $punctuality, $attendance,
        $communication, $team_coordination, $overtime,
        $crm_discipline, $professionalism, $total
    ]);

    $msg = "✅ Behavior KPI Successfully Saved!";
    $_POST = [];
}
?>
<?php include 'assets/layout_top.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Design Behavior KPI Entry</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{
    margin:0;
    font-family: "Segoe UI", Arial, sans-serif;
    background: linear-gradient(135deg,#050814,#0b0f1a);
    color:#fff;
    min-height:100vh;
}
.mesh{
    position:fixed; inset:0;
    background:
        radial-gradient(circle at 15% 20%, rgba(31,140,255,.25), transparent 45%),
        radial-gradient(circle at 80% 25%, rgba(255,138,0,.25), transparent 45%),
        linear-gradient(180deg,#03040a,#070b18);
    animation: hue 30s linear infinite;
    z-index:-5;
}
@keyframes hue{100%{filter:hue-rotate(30deg)}}

.grid{
  position:fixed; inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-1;
}
@keyframes grid{to{transform:translateY(70px)}}

.glass{
    max-width:850px;
    margin:40px auto;
    padding:30px;
    background:rgba(255,255,255,.06);
    backdrop-filter:blur(18px);
    border-radius:20px;
    border:1px solid rgba(255,255,255,.12);
    box-shadow:0 20px 45px rgba(0,0,0,.45);
}

.card{
    background:rgba(255,255,255,.07);
    border:none;
    border-radius:18px;
    color:#fff;
}
::placeholder {
  color: #888;
  opacity: 1; /* Firefox ke liye */
}

::-webkit-input-placeholder { /* Chrome, Edge, Safari */
  color: #888;
}

:-ms-input-placeholder { /* Old IE */
  color: #888;
}

label{font-weight:600;color:#b0b3c6}

.form-control,.form-select{
    background:rgba(255,255,255,.08);
    border:1px solid rgba(255,255,255,.15);
    color:#fff;
}

.form-control:focus,.form-select:focus{
    background:rgba(255,255,255,.10);
    color:#fff;
}

.btn-rounded{
    border-radius:30px;
    padding:10px 22px;
    font-weight:600;
}

.btn-glow:hover{
    box-shadow:0 0 20px rgba(255,138,0,.6);
    transform:translateY(-2px);
}

.alert{border-radius:14px}
</style>
</head>

<body>


<br><br><br>
<div class="glass">

<div class="card p-3 mb-4">
    <h4 class="mb-1">🎨 Design – Behavior KPI Entry</h4>
    <small style="color:#b0b3c6">Monthly behavior performance form</small>
</div>

<?php if($msg): ?>
<div class="alert alert-success text-center fw-semibold shadow-soft">
    <?=$msg?>
</div>
<?php endif; ?>

<form method="post">

<div class="mb-3">
    <label>Designer</label>
    <select name="designer_id" class="form-select" required
        onchange="this.form.designer_name.value=this.options[this.selectedIndex].text">
        <option value="">Select Designer</option>
        <?php foreach($designers as $d): ?>
            <option value="<?=$d['id']?>"
                <?=($_POST['designer_id']??'')==$d['id']?'selected':''?>>
                <?=$d['full_name']?>
            </option>
        <?php endforeach; ?>
    </select>
    <input type="hidden" name="designer_name">
</div>

<div class="row">
    <div class="col-md-6 mb-3">
        <label>Month</label>
        <input type="number" class="form-control" name="month" min="1" max="12"
               value="<?=htmlspecialchars($_POST['month'] ?? $month)?>">
    </div>

    <div class="col-md-6 mb-3">
        <label>Year</label>
        <input type="number" class="form-control" name="year"
               value="<?=htmlspecialchars($_POST['year'] ?? $year)?>">
    </div>
</div>

<hr class="border-light">

<h6 class="mb-3" style="color:#b0b3c6">Manual Behavior Scores</h6>

<div class="row">
    <div class="col-md-6 mb-3">
        <input type="number" class="form-control" name="communication"
               placeholder="Communication (0–3)"
               value="<?=htmlspecialchars($_POST['communication'] ?? '')?>">
    </div>

    <div class="col-md-6 mb-3">
        <input type="number" class="form-control" name="team_coordination"
               placeholder="Team Coordination (0–3)"
               value="<?=htmlspecialchars($_POST['team_coordination'] ?? '')?>">
    </div>

    <div class="col-md-6 mb-3">
        <input type="number" class="form-control" name="overtime"
               placeholder="Overtime (0–4)"
               value="<?=htmlspecialchars($_POST['overtime'] ?? '')?>">
    </div>

    <div class="col-md-6 mb-3">
        <input type="number" class="form-control" name="crm_discipline"
               placeholder="CRM Discipline (0–3)"
               value="<?=htmlspecialchars($_POST['crm_discipline'] ?? '')?>">
    </div>

    <div class="col-md-12 mb-3">
        <input type="number" class="form-control" name="professionalism"
               placeholder="Professionalism (0–2)"
               value="<?=htmlspecialchars($_POST['professionalism'] ?? '')?>">
    </div>
</div>

<div class="text-center mt-3">
    <button name="save_kpi" class="btn btn-warning btn-rounded btn-glow">
        Save KPI
    </button>
</div>

</form>
</div>

</body>
</html>
<?php include 'assets/layout_bottom.php'; ?>
