<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>

/* ================= ROOT THEME ================= */
:root{
  --blue:#0097fc;
  --orange:#ff6a00;
  --dark:#050814;
  --glowBlue:rgba(0,151,252,.6);
}

/* ================= RESET ================= */
*{
  margin:0;
  padding:0;
  box-sizing:border-box;
  font-family:Inter,Segoe UI,Arial,sans-serif;
}

html,body{
  width:100%;
  height:100%;
  background:var(--dark);
  overflow:hidden;
  color:#fff;
}

/* ================= BACKGROUND ================= */
.mesh{
  position:fixed;
  inset:0;
  background:
    radial-gradient(circle at 20% 20%, rgba(0,151,252,.35), transparent 45%),
    radial-gradient(circle at 80% 30%, rgba(255,106,0,.3), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:0;
}
@keyframes mesh{
  from{filter:hue-rotate(0deg)}
  to{filter:hue-rotate(25deg)}
}

.grid{
  position:fixed;
  inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:1;
}
@keyframes grid{
  to{transform:translateY(70px)}
}

#particles{
  position:fixed;
  inset:0;
  z-index:2;
}

/* ================= SPLASH ================= */
#splash{
  position:fixed;
  inset:0;
  display:flex;
  align-items:center;
  justify-content:center;
  background:radial-gradient(circle at center, rgba(0, 151, 252, 0.24), #0508144a 75%);
  z-index:10;
}

.splash-box{
  text-align:center;
  animation:pop .9s ease;
}
@keyframes pop{
  from{opacity:0;transform:scale(.9)}
  to{opacity:1}
}

/* ================= LOGO ================= */
.logo-text{
  font-size:90px;
  font-weight:700;
  letter-spacing:1px;
}
.logo-text .j{
  color:var(--blue);
  text-shadow:0 0 20px var(--glowBlue);
}
.logo-text .g{
  color:var(--orange);
  text-shadow:0 0 20px rgba(255,106,0,.6);
}
.logo-text .suite{
  color:#ffffff;
  font-weight:500;
  margin-left:6px;
  font-size:88px;
}

.tagline{
  font-size:22px;
  opacity:.6;
  margin:6px 0 26px;
  letter-spacing:.6px;
}

/* ================= LOADER ================= */
.loader-bar{
  width:280px;
  height:6px;
  background:rgba(255,255,255,.1);
  border-radius:20px;
  overflow:hidden;
  margin:0 auto 14px;
}
.loader-bar span{
  display:block;
  height:100%;
  width:40%;
  background:linear-gradient(90deg,var(--blue),var(--orange));
  animation:load 1.8s ease-in-out infinite;
}
@keyframes load{
  0%{transform:translateX(-120%)}
  100%{transform:translateX(320%)}
}

#bootText{
  font-size:13px;
  opacity:.7;
  letter-spacing:.5px;
}

.powered{
  margin-top:10px;
  font-size:19px;
  opacity:.6;
}

</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ================= SPLASH ================= -->
<div id="splash">
  <div class="splash-box">

    <div class="logo-text">
      <span class="j">J</span><span class="g">G</span>
      <span class="suite">Suite</span>
    </div>

    <div class="tagline">Enterprise JG Software</div>

    <div class="loader-bar"><span></span></div>

    <div id="bootText">Initializing Intelligent Enterprise Core…</div>
    <br><br>
    <div class="powered">Powered by Jillion Gamuts</div>

  </div>
</div>

<script>
/* ================= PARTICLES ================= */
const canvas = document.getElementById("particles");
const ctx = canvas.getContext("2d");

let w = canvas.width = window.innerWidth;
let h = canvas.height = window.innerHeight;

window.addEventListener("resize",()=>{
  w = canvas.width = window.innerWidth;
  h = canvas.height = window.innerHeight;
});

class Particle{
  constructor(){
    this.x=Math.random()*w;
    this.y=Math.random()*h;
    this.size=Math.random()*3+1;
    this.vx=(Math.random()-0.5)*1.2;
    this.vy=(Math.random()-0.5)*1.2;
    this.color=Math.random()>.5?"#0097fc":"#ff6a00";
  }
  draw(){
    ctx.beginPath();
    ctx.arc(this.x,this.y,this.size,0,Math.PI*2);
    ctx.fillStyle=this.color;
    ctx.fill();
  }
  update(){
    this.x+=this.vx;
    this.y+=this.vy;
    if(this.x<0||this.x>w) this.vx*=-1;
    if(this.y<0||this.y>h) this.vy*=-1;
  }
}

const particles=[];
for(let i=0;i<120;i++) particles.push(new Particle());

function connect(){
  for(let a=0;a<particles.length;a++){
    for(let b=a;b<particles.length;b++){
      const dx=particles[a].x-particles[b].x;
      const dy=particles[a].y-particles[b].y;
      const d=Math.sqrt(dx*dx+dy*dy);
      if(d<120){
        ctx.strokeStyle="rgba(0,151,252,.18)";
        ctx.beginPath();
        ctx.moveTo(particles[a].x,particles[a].y);
        ctx.lineTo(particles[b].x,particles[b].y);
        ctx.stroke();
      }
    }
  }
}

(function animate(){
  ctx.clearRect(0,0,w,h);
  particles.forEach(p=>{p.update();p.draw();});
  connect();
  requestAnimationFrame(animate);
})();

/* ================= BOOT TEXT ================= */
const texts = [
  "Initializing Intelligent Enterprise Core…",
  "Orchestrating Organizational Workflows…",
  "Connecting Analytics, Operations & Control…",
  "Enforcing Secure Governance Architecture…",
  "JG Suite — Powering Modern Enterprises"
];

let i = 0;
setInterval(()=>{
  document.getElementById("bootText").innerText = texts[i];
  i = (i+1) % texts.length;
}, 2800);
</script>

</body>
</html>
